/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringIntegrationUtil {
    private SpringIntegrationUtil() {
    }

    @NotNull
    public static List<SpringBeanPointer> getMessageChannels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/integration/util/SpringIntegrationUtil", "getMessageChannels"));
        }
        PsiClass messageChannel = SpringIntegrationUtil.isSpringIntegration4Used(module) ? SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.messaging.MessageChannel") : SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.MessageChannel");
        if (messageChannel == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/util/SpringIntegrationUtil", "getMessageChannels"));
            }
            return list;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)messageChannel).withInheritors();
        SpringModel springModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        List list = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/util/SpringIntegrationUtil", "getMessageChannels"));
        }
        return list;
    }

    public static boolean isSpringIntegration4Used(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.IntegrationMessageHeaderAccessor") != null;
    }

    public static boolean isSpringIntegrationUsed(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.integration.channel.DirectChannel") != null;
    }
}

