/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.admin;

import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerParameters;
import com.intellij.j2ee.webSphere.client.WebSphereClientFactory;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDeploymentModel;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.util.ILogger;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebSphereAdminServerImpl
extends JavaeeAgentAdminServerBase {
    private final WebSphereVersion myVersion;
    private final WebSphereAdminServerParameters myParameters;
    private final boolean myDeploymentSupported;
    private final Consumer<String> myProfileConsumer;
    private static final String SPECIFICS_MODULE_NAME = "webSphereClientImpl";
    private static final String SPECIFICS_JAR_PATH = "specifics/webSphereClientImpl.jar";

    public WebSphereAdminServerImpl(ProcessAgentProxyFactory agentProxyFactory, List<File> instanceLibraries, WebSphereVersion version, WebSphereAdminServerParameters parameters, boolean deploymentSupported, Consumer<String> profileConsumer) throws Exception {
        super((AgentProxyFactory)agentProxyFactory, instanceLibraries, Arrays.asList(WebSphereClientFactory.class), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, "com.intellij.j2ee.webSphere.agent.WebSphereAgent");
        this.myVersion = version;
        this.myParameters = parameters;
        this.myDeploymentSupported = deploymentSupported;
        this.myProfileConsumer = profileConsumer;
    }

    protected void setupInitParameters(ParametersMap initParameters) {
        initParameters.put((Object)"has.auto.upload", (Object)Boolean.toString(this.myVersion.hasAutoUpload()));
        initParameters.put((Object)"is.use.ibm.algorithm", (Object)Boolean.toString(this.myVersion.isUseIbmAlgorithm()));
        initParameters.put((Object)"is.secured", (Object)Boolean.toString(this.myParameters.isSecured()));
        initParameters.put((Object)"trust.store.path", (Object)this.myParameters.getTrustStorePath());
        initParameters.put((Object)"trust.store.password", (Object)this.myParameters.getTrustStorePassword());
        initParameters.put((Object)"key.store.path", (Object)this.myParameters.getKeyStorePath());
        initParameters.put((Object)"key.store.password", (Object)this.myParameters.getKeyStorePassword());
        initParameters.put((Object)"cell.name", (Object)this.myParameters.getCellName());
        initParameters.put((Object)"node.name", (Object)this.myParameters.getNodeName());
        initParameters.put((Object)"server.name", (Object)this.myParameters.getServerName());
        initParameters.put((Object)"is.upload.ear.before.deploy", (Object)Boolean.toString(this.myParameters.isUploadEARBeforeDeploy()));
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) throws Exception {
        deployParameters.put((Object)"ejb.deploy.enabled", (Object)Boolean.toString(((WebSphereDeploymentModel)deployment).EJB_DEPLOY_TOOL_ENABLED && WebSphereAdminServerImpl.containsEjbFacet(deployment) != false));
    }

    private static Boolean containsEjbFacet(final DeploymentModel deployment) {
        final Artifact artifact = deployment.getArtifact();
        if (artifact == null) {
            return false;
        }
        return (Boolean)new WriteAction<Boolean>(){

            protected void run(@NotNull Result<Boolean> booleanResult) throws Throwable {
                if (booleanResult == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "booleanResult", "com/intellij/j2ee/webSphere/admin/WebSphereAdminServerImpl$1", "run"));
                }
                Collection facets = JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(deployment.getCommonModel().getProject(), artifact, EjbFacet.ID);
                booleanResult.setResult((Object)(!facets.isEmpty() ? 1 : 0));
            }
        }.execute().getResultObject();
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) throws Exception {
        String string = WebSphereAdminServerImpl.getDeploymentName(deployment);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/admin/WebSphereAdminServerImpl", "getDeploymentName"));
        }
        return string;
    }

    public static String getDeploymentName(DeploymentModel deployment) {
        return WebSphereAdminServerImpl.getBackMinuses(deployment, JavaeeDeploymentProvider.getDefaultDeploymentName((DeploymentModel)deployment));
    }

    private static String getBackMinuses(DeploymentModel deployment, String deploymentName) {
        String originalDeploymentName = JavaeeDeploymentProvider.getFacetDefinedDeploymentName((DeploymentModel)deployment);
        if (originalDeploymentName == null) {
            originalDeploymentName = deployment.getDeploymentSource().getPresentableName();
        }
        char[] chars = deploymentName.toCharArray();
        for (int i = 0; i < deploymentName.length(); ++i) {
            if (originalDeploymentName.charAt(i) != '-' || chars[i] != '_') continue;
            chars[i] = 45;
        }
        return new String(chars);
    }

    public void startDeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        if (!this.myDeploymentSupported) {
            return;
        }
        super.startDeploy(deployment, source, callback);
    }

    public void startUndeploy(DeploymentModel deployment, File source, JavaeeAdminDeployCallback callback) {
        if (!this.myDeploymentSupported) {
            return;
        }
        super.startUndeploy(deployment, source, callback);
    }

    public void start(String host, int port, String username, String password, final JavaeeAdminStartCallback callback) throws Exception {
        super.start(host, port, username, password, new JavaeeAdminStartCallback(){

            public void updateDeploymentStatus() {
                callback.updateDeploymentStatus();
            }

            public ILogger getLogger() {
                return new ILogger(){

                    public void debugEx(Exception e) {
                        callback.getLogger().debugEx(e);
                    }

                    public void errorEx(Exception e) {
                        callback.getLogger().errorEx(e);
                    }

                    public void debug(String message) {
                        callback.getLogger().debug(message);
                    }

                    public void error(String message) {
                        callback.getLogger().error(message);
                    }

                    public void info(String message) {
                        WebSphereAdminServerImpl.this.myProfileConsumer.consume((Object)message);
                        callback.getLogger().info(message);
                    }
                };
            }
        });
    }
}

