/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinResult;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.CheckinWorkItemAction;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Failure;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.PendingChange;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.actions.SingleItemAction;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyGetOperations;
import org.jetbrains.tfsIntegration.core.tfs.operations.ApplyProgress;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.core.tfs.workitems.WorkItem;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.CreateBranchDialog;

public class BranchAction
extends SingleItemAction
implements DumbAware {
    @Override
    protected void execute(final @NotNull Project project, final @NotNull WorkspaceInfo workspace, @NotNull FilePath sourceLocalPath, @NotNull ExtendedItem sourceExtendedItem) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/actions/BranchAction", "execute"));
        }
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/actions/BranchAction", "execute"));
        }
        if (sourceLocalPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceLocalPath", "org/jetbrains/tfsIntegration/actions/BranchAction", "execute"));
        }
        if (sourceExtendedItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceExtendedItem", "org/jetbrains/tfsIntegration/actions/BranchAction", "execute"));
        }
        try {
            FilePath targetLocalPath;
            ResultWithFailures<GetOperation> createBranchResult;
            FilePath targetLocalPath2;
            String sourceServerPath = sourceExtendedItem.getSitem();
            CreateBranchDialog d = new CreateBranchDialog(project, workspace, sourceServerPath, sourceExtendedItem.getType() == ItemType.Folder);
            if (!d.showAndGet()) {
                return;
            }
            VersionSpecBase version = d.getVersionSpec();
            if (version == null) {
                Messages.showErrorDialog((Project)project, (String)"Incorrect version specified", (String)"Create Branch");
                return;
            }
            String targetServerPath = d.getTargetPath();
            if (d.isCreateWorkingCopies() && (targetLocalPath2 = workspace.findLocalPathByServerPath(targetServerPath, true, project)) == null) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setTitle("Select Local Folder");
                descriptor.setShowFileSystemRoots(true);
                String message = MessageFormat.format("Branch target folder ''{0}'' is not mapped. Select a local folder to create a mapping in workspace ''{1}''", targetServerPath, workspace.getName());
                descriptor.setDescription(message);
                VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
                if (virtualFile == null) {
                    return;
                }
                workspace.addWorkingFolderInfo(new WorkingFolderInfo(WorkingFolderInfo.Status.Active, TfsFileUtil.getFilePath(virtualFile), targetServerPath));
                workspace.saveToServer(project, workspace);
            }
            if (!(createBranchResult = workspace.getServer().getVCS().createBranch(workspace.getName(), workspace.getOwnerName(), sourceServerPath, version, targetServerPath, project, TFSBundle.message("creating.branch", new Object[0]))).getFailures().isEmpty()) {
                StringBuilder s = new StringBuilder("Failed to create branch:\n");
                for (Failure failure : createBranchResult.getFailures()) {
                    s.append(failure.getMessage()).append("\n");
                }
                Messages.showErrorDialog((Project)project, (String)s.toString(), (String)"Create Branch");
                return;
            }
            if (d.isCreateWorkingCopies()) {
                final Ref downloadErrors = new Ref(Collections.emptyList());
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        downloadErrors.set(ApplyGetOperations.execute(project, workspace, createBranchResult.getResult(), new ApplyProgress.ProgressIndicatorWrapper(ProgressManager.getInstance().getProgressIndicator()), null, ApplyGetOperations.DownloadMode.ALLOW));
                    }
                }, "Creating target working copies", false, project);
                if (!((Collection)downloadErrors.get()).isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)project).showErrors(new ArrayList((Collection)downloadErrors.get()), "Create Branch");
                }
            }
            Collection<PendingChange> pendingChanges = workspace.getServer().getVCS().queryPendingSetsByServerItems(workspace.getName(), workspace.getOwnerName(), Collections.singletonList(targetServerPath), RecursionType.Full, project, TFSBundle.message("loading.changes", new Object[0]));
            ArrayList<String> checkin = new ArrayList<String>();
            for (PendingChange change : pendingChanges) {
                if (!new ChangeTypeMask(change.getChg()).contains(ChangeType_type0.Branch)) continue;
                checkin.add(change.getItem());
            }
            String string = MessageFormat.format("Branched from {0}", sourceServerPath);
            ResultWithFailures<CheckinResult> checkinResult = workspace.getServer().getVCS().checkIn(workspace.getName(), workspace.getOwnerName(), checkin, string, Collections.<WorkItem, CheckinWorkItemAction>emptyMap(), Collections.<Pair<String, String>>emptyList(), null, project, TFSBundle.message("checking.in", new Object[0]));
            if (!checkinResult.getFailures().isEmpty()) {
                List<VcsException> checkinErrors = TfsUtil.getVcsExceptions(checkinResult.getFailures());
                AbstractVcsHelper.getInstance((Project)project).showErrors(checkinErrors, "Create Branch");
            }
            if ((targetLocalPath = workspace.findLocalPathByServerPath(targetServerPath, true, project)) != null) {
                TfsFileUtil.markDirtyRecursively(project, targetLocalPath);
            }
            String message = MessageFormat.format("''{0}'' branched successfully to ''{1}''.", sourceServerPath, targetServerPath);
            Messages.showInfoMessage((Project)project, (String)message, (String)"Create Branch");
        }
        catch (TfsException ex) {
            String message = "Failed to create branch: " + ex.getMessage();
            Messages.showErrorDialog((Project)project, (String)message, (String)"Create Branch");
        }
    }
}

