/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LogDecoder {
    private LogDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: LogDecoder idea.log output.log");
            return;
        }
        FileInputStream is = null;
        OutputStreamWriter os = null;
        try {
            is = new FileInputStream(args[0]);
            os = new OutputStreamWriter(new FileOutputStream(args[1]));
            List<Entry> entries = LogDecoder.decode(is);
            for (Entry entry : entries) {
                os.write(entry.getText());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List<Entry> decode(InputStream inputStream) throws IOException {
        String line;
        ArrayList<Entry> result = new ArrayList<Entry>();
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<MessageType, String> session = null;
        MessageType currentType = null;
        StringBuilder accumulated = new StringBuilder();
        while ((line = r.readLine()) != null) {
            MessageType lineType = null;
            for (MessageType type : MessageType.values()) {
                if (!line.contains(type.getPrefix())) continue;
                lineType = type;
                int beginIndex = line.indexOf(type.getPrefix()) + type.getPrefix().length();
                int endIndex = line.lastIndexOf(type.getSuffix());
                line = line.substring(beginIndex, endIndex);
                break;
            }
            if (lineType == null) {
                result.add(new UnknownEntry(line));
                continue;
            }
            if (session == null) {
                session = new HashMap<MessageType, String>();
            } else if (session.containsKey((Object)currentType)) {
                result.add(new SessionEntry(session));
                session = new HashMap();
            }
            if (currentType != null && lineType != currentType) {
                byte[] unescaped = LogDecoder.unescape(accumulated.toString());
                String unzipped = null;
                if (currentType == MessageType.ContentIn) {
                    unzipped = LogDecoder.tryUnzip(unescaped);
                }
                String display = unzipped != null ? unzipped : new String(unescaped);
                display = LogDecoder.tryPrettyPrintXml(display);
                session.put(currentType, display);
                accumulated = new StringBuilder();
            }
            accumulated.append(line);
            currentType = lineType;
        }
        if (session != null) {
            result.add(new SessionEntry(session));
        }
        return result;
    }

    private static byte[] unescape(String escaped) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = 0;
        while (i < escaped.length()) {
            if (escaped.startsWith("[\\r]", i)) {
                os.write(13);
                i += "[\\r]".length();
                continue;
            }
            if (escaped.startsWith("[\\n]", i)) {
                os.write(10);
                i += "[\\n]".length();
                continue;
            }
            if (escaped.startsWith("[0x", i)) {
                int closingBracket = escaped.indexOf(93, i);
                String hex = escaped.substring(i + 3, closingBracket);
                byte ch = (byte)Integer.parseInt(hex, 16);
                os.write(ch);
                i = closingBracket + 1;
                continue;
            }
            os.write(escaped.charAt(i));
            ++i;
        }
        return os.toByteArray();
    }

    private static boolean equal(byte[] a1, int a1start, byte[] a2, int length) {
        for (int i = 0; i < length; ++i) {
            if (a1[a1start + i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static String tryUnzip(byte[] zipped) {
        try {
            String line;
            ByteArrayInputStream is = new ByteArrayInputStream(zipped);
            ChunkedInputStream cs = new ChunkedInputStream((InputStream)is);
            GZIPInputStream zs = new GZIPInputStream((InputStream)cs);
            BufferedReader r = new BufferedReader(new InputStreamReader(zs));
            StringBuilder result = new StringBuilder();
            while ((line = r.readLine()) != null) {
                result.append(line).append("\n");
            }
            return result.toString();
        }
        catch (IOException e) {
            if (!"Not in GZIP format".equals(e.getMessage())) {
                e.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(byte[] bytes, String file) {
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(file);
            f.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String tryPrettyPrintXml(String xml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource sourceXML = new InputSource(new StringReader(xml));
            Document xmlDoc = db.parse(sourceXML);
            Element e = xmlDoc.getDocumentElement();
            e.normalize();
            StringWriter result = new StringWriter();
            OutputFormat format = new OutputFormat(xmlDoc);
            format.setIndenting(true);
            format.setIndent(2);
            XMLSerializer serializer = new XMLSerializer(result, format);
            serializer.serialize(xmlDoc);
            return result.toString();
        }
        catch (Exception e) {
            return xml;
        }
    }

    private static class UnknownEntry
    implements Entry {
        private final String myText;

        public UnknownEntry(String text) {
            this.myText = text;
        }

        @Override
        public String getText() {
            return this.myText + "\n";
        }
    }

    private static class SessionEntry
    implements Entry {
        private final Map<MessageType, String> mySession;

        public SessionEntry(Map<MessageType, String> session) {
            this.mySession = session;
        }

        @Override
        public String getText() {
            StringBuilder s = new StringBuilder();
            for (MessageType t : MessageType.values()) {
                String[] lines;
                if (!this.mySession.containsKey((Object)t)) continue;
                for (String line : lines = this.mySession.get((Object)t).split("\n")) {
                    if (line.length() <= 0 || "\n".equals(line.trim())) continue;
                    s.append(t.getPrefix()).append(line).append("\n");
                }
            }
            return s.toString();
        }
    }

    private static enum MessageType {
        HeaderOut("header - >> \"", "\""),
        ContentOut("content - >> \"", "\""),
        HeaderIn("header - << \"", "\""),
        ContentIn("content - << \"", "\"");

        private final String myPrefix;
        private final String mySuffix;

        private MessageType(String prefix, String suffix) {
            this.myPrefix = prefix;
            this.mySuffix = suffix;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public String getSuffix() {
            return this.mySuffix;
        }
    }

    private static interface Entry {
        public String getText();
    }
}

