/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Change;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ChangeType_type0;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Changeset;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.ChangeTypeMask;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSChangeList
implements CommittedChangeList {
    public static final boolean IDEADEV_29451_WORKAROUND = true;
    private WorkspaceInfo myWorkspace;
    private final TFSVcs myVcs;
    private int myRevisionNumber;
    private String myAuthor;
    private Date myDate;
    @NotNull
    private String myComment;
    private List<com.intellij.openapi.vcs.changes.Change> myCachedChanges;
    private final Map<FilePath, Integer> myModifiedPaths = new HashMap<FilePath, Integer>();
    private final Set<FilePath> myAddedPaths = new HashSet<FilePath>();
    private final Map<FilePath, Integer> myDeletedPaths = new HashMap<FilePath, Integer>();
    private final Map<FilePath, Pair<FilePath, Integer>> myMovedPaths = new HashMap<FilePath, Pair<FilePath, Integer>>();
    private URI myServerUri;
    private String myWorkspaceName;

    public TFSChangeList(TFSVcs vcs, DataInput stream) {
        this.myVcs = vcs;
        this.readFromStream(stream);
    }

    public TFSChangeList(WorkspaceInfo workspace, int revisionNumber, String author, Date date, String comment, TFSVcs vcs) {
        this.myWorkspace = workspace;
        this.myRevisionNumber = revisionNumber;
        this.myAuthor = author;
        this.myDate = date;
        this.myComment = comment != null ? comment : "";
        this.myVcs = vcs;
        this.myWorkspaceName = this.myWorkspace.getName();
        this.myServerUri = this.myWorkspace.getServer().getUri();
    }

    public String getCommitterName() {
        return this.myAuthor;
    }

    public Date getCommitDate() {
        return this.myDate;
    }

    public long getNumber() {
        return this.myRevisionNumber;
    }

    @Nullable
    public String getBranch() {
        return null;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Collection<com.intellij.openapi.vcs.changes.Change> getChanges() {
        if (this.myCachedChanges == null) {
            try {
                TFSContentRevision afterRevision;
                TFSContentRevision beforeRevision;
                if (this.myWorkspace != null) {
                    this.loadChanges();
                }
                this.myCachedChanges = new ArrayList<com.intellij.openapi.vcs.changes.Change>();
                for (FilePath filePath : this.myAddedPaths) {
                    this.myCachedChanges.add(new com.intellij.openapi.vcs.changes.Change(null, (ContentRevision)TFSContentRevision.create(this.myVcs.getProject(), filePath, this.myRevisionNumber)));
                }
                for (Map.Entry entry : this.myDeletedPaths.entrySet()) {
                    this.myCachedChanges.add(new com.intellij.openapi.vcs.changes.Change((ContentRevision)TFSContentRevision.create(this.myVcs.getProject(), (FilePath)entry.getKey(), (Integer)entry.getValue()), null));
                }
                for (Map.Entry entry : this.myModifiedPaths.entrySet()) {
                    beforeRevision = TFSContentRevision.create(this.myVcs.getProject(), (FilePath)entry.getKey(), (Integer)entry.getValue());
                    afterRevision = TFSContentRevision.create(this.myVcs.getProject(), (FilePath)entry.getKey(), this.myRevisionNumber);
                    this.myCachedChanges.add(new com.intellij.openapi.vcs.changes.Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision));
                }
                for (Map.Entry entry : this.myMovedPaths.entrySet()) {
                    beforeRevision = TFSContentRevision.create(this.myVcs.getProject(), (FilePath)entry.getKey(), (Integer)((Pair)entry.getValue()).second);
                    afterRevision = TFSContentRevision.create(this.myVcs.getProject(), (FilePath)((Pair)entry.getValue()).first, this.myRevisionNumber);
                    this.myCachedChanges.add(new com.intellij.openapi.vcs.changes.Change((ContentRevision)beforeRevision, null));
                    this.myCachedChanges.add(new com.intellij.openapi.vcs.changes.Change(null, (ContentRevision)afterRevision));
                }
            }
            catch (TfsException e) {
                AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showError(new VcsException(e.getMessage(), (Throwable)e), "TFS");
            }
        }
        return this.myCachedChanges;
    }

    public Collection<com.intellij.openapi.vcs.changes.Change> getChangesWithMovedTrees() {
        return this.getChanges();
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.myComment = newMessage;
    }

    @NotNull
    public String getName() {
        String string = this.myComment;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSChangeList", "getName"));
        }
        return string;
    }

    @NotNull
    public String getComment() {
        String string = this.myComment;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSChangeList", "getComment"));
        }
        return string;
    }

    void writeToStream(DataOutput stream) throws IOException {
        stream.writeUTF(this.myServerUri.toString());
        stream.writeUTF(this.myWorkspaceName);
        stream.writeInt(this.myRevisionNumber);
        stream.writeUTF(this.myAuthor);
        stream.writeLong(this.myDate.getTime());
        stream.writeUTF(this.myComment);
        TFSChangeList.writePathsInts(stream, this.myModifiedPaths);
        TFSChangeList.writePaths(stream, this.myAddedPaths);
        TFSChangeList.writePathsInts(stream, this.myDeletedPaths);
        TFSChangeList.writeMoved(stream, this.myMovedPaths);
    }

    private void loadChanges() {
        try {
            Changeset changeset = this.myWorkspace.getServer().getVCS().queryChangeset(this.myRevisionNumber, this.myVcs.getProject(), TFSBundle.message("loading.changes", new Object[0]));
            for (Change change : changeset.getChanges().getChange()) {
                this.processChange(changeset.getCset(), change);
            }
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showError(new VcsException(e.getMessage(), (Throwable)e), "TFS");
        }
    }

    private void processChange(int changeset, Change change) throws TfsException {
        ChangeTypeMask changeType = new ChangeTypeMask(change.getType());
        FilePath localPath = this.myWorkspace.findLocalPathByServerPath(change.getItem().getItem(), change.getItem().getType() == ItemType.Folder, this.getVcs().getProject());
        if (localPath == null) {
            return;
        }
        if (changeType.containsAny(ChangeType_type0.Add, ChangeType_type0.Undelete, ChangeType_type0.Branch)) {
            if (changeType.contains(ChangeType_type0.Add)) {
                TFSVcs.assertTrue(changeType.contains(ChangeType_type0.Encoding));
                if (change.getItem().getType() == ItemType.File) {
                    TFSVcs.assertTrue(changeType.contains(ChangeType_type0.Edit));
                } else {
                    TFSVcs.assertTrue(!changeType.contains(ChangeType_type0.Edit));
                }
            }
            TFSVcs.assertTrue(!changeType.contains(ChangeType_type0.Delete));
            this.myAddedPaths.add(localPath);
            return;
        }
        if (changeType.contains(ChangeType_type0.Delete)) {
            TFSVcs.assertTrue(changeType.size() <= 3, "Unexpected change type: " + changeType);
            int previousCs = change.getItem().getCs() - 1;
            this.myDeletedPaths.put(localPath, previousCs);
            return;
        }
        if (changeType.contains(ChangeType_type0.Rename)) {
            if (change.getItem().getDid() != Integer.MIN_VALUE) {
                return;
            }
            Item item = this.getPreviousVersion(change.getItem(), changeset);
            FilePath originalPath = this.myWorkspace.findLocalPathByServerPath(item.getItem(), item.getType() == ItemType.Folder, this.getVcs().getProject());
            if (originalPath != null) {
                this.myMovedPaths.put(originalPath, (Pair<FilePath, Integer>)Pair.create((Object)localPath, (Object)item.getCs()));
            }
            return;
        }
        if (changeType.containsAny(ChangeType_type0.Edit, ChangeType_type0.Merge)) {
            int previousCs = change.getItem().getCs() - 1;
            this.myModifiedPaths.put(localPath, previousCs);
            return;
        }
        TFSVcs.error("Unknown change: " + changeType + " for item " + change.getItem().getItem());
    }

    private void readFromStream(DataInput stream) {
        try {
            this.myServerUri = new URI(stream.readUTF());
            this.myWorkspaceName = stream.readUTF();
            this.myRevisionNumber = stream.readInt();
            this.myAuthor = stream.readUTF();
            this.myDate = new Date(stream.readLong());
            this.myComment = stream.readUTF();
            TFSChangeList.readPathsInts(stream, this.myModifiedPaths);
            TFSChangeList.readPaths(stream, this.myAddedPaths);
            TFSChangeList.readPathsInts(stream, this.myDeletedPaths);
            TFSChangeList.readMoved(stream, this.myMovedPaths);
        }
        catch (IOException e) {
            AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showError(new VcsException((Throwable)e), "TFS");
        }
        catch (URISyntaxException e) {
            AbstractVcsHelper.getInstance((Project)this.myVcs.getProject()).showError(new VcsException((Throwable)e), "TFS");
        }
    }

    private static void writePaths(DataOutput stream, Collection<FilePath> paths) throws IOException {
        stream.writeInt(paths.size());
        for (FilePath path : paths) {
            TFSChangeList.writePath(stream, path);
        }
    }

    private static void writePathsInts(DataOutput stream, Map<FilePath, Integer> paths) throws IOException {
        stream.writeInt(paths.size());
        for (Map.Entry<FilePath, Integer> e : paths.entrySet()) {
            TFSChangeList.writePath(stream, e.getKey());
            stream.writeInt(e.getValue());
        }
    }

    private static void writeMoved(DataOutput stream, Map<FilePath, Pair<FilePath, Integer>> paths) throws IOException {
        stream.writeInt(paths.size());
        for (Map.Entry<FilePath, Pair<FilePath, Integer>> e : paths.entrySet()) {
            TFSChangeList.writePath(stream, e.getKey());
            TFSChangeList.writePath(stream, (FilePath)e.getValue().first);
            stream.writeInt((Integer)e.getValue().second);
        }
    }

    private static void writePath(DataOutput stream, FilePath path) throws IOException {
        stream.writeUTF(path.getPath());
        stream.writeBoolean(path.isDirectory());
    }

    private static void readPaths(DataInput stream, Collection<FilePath> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.add(TFSChangeList.readPath(stream));
        }
    }

    private static void readPathsInts(DataInput stream, Map<FilePath, Integer> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.put(TFSChangeList.readPath(stream), stream.readInt());
        }
    }

    private static void readMoved(DataInput stream, Map<FilePath, Pair<FilePath, Integer>> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.put(TFSChangeList.readPath(stream), (Pair<FilePath, Integer>)Pair.create((Object)TFSChangeList.readPath(stream), (Object)stream.readInt()));
        }
    }

    private static FilePath readPath(DataInput stream) throws IOException {
        return VcsUtil.getFilePath((String)stream.readUTF(), (boolean)stream.readBoolean());
    }

    private Item getPreviousVersion(Item item, int changeset) throws TfsException {
        ItemSpec itemSpec = VersionControlServer.createItemSpec(item.getItem(), item.getDid(), RecursionType.None);
        List<Changeset> shortHistory = this.myWorkspace.getServer().getVCS().queryHistory(this.myWorkspace.getName(), this.myWorkspace.getOwnerName(), itemSpec, null, new ChangesetVersionSpec(changeset), new ChangesetVersionSpec(1), new ChangesetVersionSpec(item.getCs()), 2, this.myVcs.getProject(), TFSBundle.message("loading.history", new Object[0]));
        TFSVcs.assertTrue(shortHistory.size() == 2);
        return shortHistory.get(1).getChanges().getChange()[0].getItem();
    }

    public String toString() {
        return this.myComment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TFSChangeList that = (TFSChangeList)o;
        if (this.myRevisionNumber != that.myRevisionNumber) {
            return false;
        }
        if (this.myAuthor != null ? !this.myAuthor.equals(that.myAuthor) : that.myAuthor != null) {
            return false;
        }
        if (this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null) {
            return false;
        }
        if (this.myServerUri != null ? !this.myServerUri.equals(that.myServerUri) : that.myServerUri != null) {
            return false;
        }
        return !(this.myWorkspaceName != null ? !this.myWorkspaceName.equals(that.myWorkspaceName) : that.myWorkspaceName != null);
    }

    public int hashCode() {
        int result = this.myRevisionNumber;
        result = 31 * result + (this.myAuthor != null ? this.myAuthor.hashCode() : 0);
        result = 31 * result + (this.myDate != null ? this.myDate.hashCode() : 0);
        result = 31 * result + (this.myServerUri != null ? this.myServerUri.hashCode() : 0);
        result = 31 * result + (this.myWorkspaceName != null ? this.myWorkspaceName.hashCode() : 0);
        return result;
    }
}

