/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.UpdateWorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;

@State(name="TFS", storages={@Storage(file="$WORKSPACE_FILE$")})
public class TFSProjectConfiguration
implements PersistentStateComponent<ConfigurationBean> {
    private ConfigurationBean myConfigurationBean;
    private final Map<WorkspaceInfo, UpdateWorkspaceInfo> myUpdateWorkspaceInfos = new HashMap<WorkspaceInfo, UpdateWorkspaceInfo>();

    public TFSProjectConfiguration() {
        this.myConfigurationBean = new ConfigurationBean();
    }

    @Nullable
    public static TFSProjectConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/core/TFSProjectConfiguration", "getInstance"));
        }
        return (TFSProjectConfiguration)ServiceManager.getService((Project)project, TFSProjectConfiguration.class);
    }

    @NotNull
    public ConfigurationBean getState() {
        ConfigurationBean configurationBean = this.myConfigurationBean;
        if (configurationBean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSProjectConfiguration", "getState"));
        }
        return configurationBean;
    }

    public void loadState(ConfigurationBean state) {
        this.myConfigurationBean = state;
    }

    public UpdateWorkspaceInfo getUpdateWorkspaceInfo(WorkspaceInfo workspace) {
        UpdateWorkspaceInfo info = this.myUpdateWorkspaceInfos.get(workspace);
        if (info == null) {
            info = new UpdateWorkspaceInfo(LatestVersionSpec.INSTANCE);
            this.myUpdateWorkspaceInfos.put(workspace, info);
        }
        return info;
    }

    public static class ConfigurationBean {
        public boolean UPDATE_RECURSIVELY = true;
    }
}

