/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.configuration;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.ServerConfiguration;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

@com.intellij.openapi.components.State(name="org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager", storages={@Storage(file="$APP_CONFIG$/tfs.xml")})
public class TFSConfigurationManager
implements PersistentStateComponent<State> {
    private static final String TFS_NOTIFICATION_GROUP = "TFS";
    private Map<String, ServerConfiguration> myServersConfig = new HashMap<String, ServerConfiguration>();
    private boolean myUseIdeaHttpProxy = true;
    private boolean mySupportTfsCheckinPolicies = true;
    private boolean mySupportStatefulCheckinPolicies = true;
    private boolean myReportNotInstalledCheckinPolicies = true;

    @NotNull
    public static synchronized TFSConfigurationManager getInstance() {
        TFSConfigurationManager tFSConfigurationManager = (TFSConfigurationManager)ServiceManager.getService(TFSConfigurationManager.class);
        if (tFSConfigurationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "getInstance"));
        }
        return tFSConfigurationManager;
    }

    @Nullable
    public synchronized Credentials getCredentials(@NotNull URI serverUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "getCredentials"));
        }
        ServerConfiguration serverConfiguration = this.getConfiguration(serverUri);
        return serverConfiguration != null ? serverConfiguration.getCredentials() : null;
    }

    public synchronized boolean isAuthCanceled(URI serverUri) {
        ServerConfiguration serverConfiguration = this.getConfiguration(serverUri);
        return serverConfiguration != null && serverConfiguration.getAuthCanceledNotification() != null;
    }

    public synchronized void setAuthCanceled(final URI serverUri, @Nullable Object projectOrComponent) {
        ServerConfiguration serverConfiguration = this.getOrCreateServerConfiguration(serverUri);
        if (serverConfiguration.getAuthCanceledNotification() != null) {
            return;
        }
        final Project project = projectOrComponent instanceof Project ? (Project)projectOrComponent : null;
        final Notification notification = new Notification(TFS_NOTIFICATION_GROUP, TFSBundle.message("notification.auth.canceled.title", TfsUtil.getPresentableUri(serverUri)), TFSBundle.message("notification.auth.canceled.text", new Object[0]), NotificationType.ERROR, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager$1", "hyperlinkUpdate"));
                }
                try {
                    TfsServerConnectionHelper.ensureAuthenticated(project, serverUri, true);
                    notification.expire();
                }
                catch (TfsException tfsException) {
                    // empty catch block
                }
            }
        });
        serverConfiguration.setAuthCanceledNotification(notification);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Notifications.Bus.notify((Notification)notification, null);
            }
        });
    }

    @Nullable
    public URI getProxyUri(@NotNull URI serverUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "getProxyUri"));
        }
        ServerConfiguration serverConfiguration = this.getConfiguration(serverUri);
        try {
            return serverConfiguration != null && serverConfiguration.getProxyUri() != null ? new URI(serverConfiguration.getProxyUri()) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldTryProxy(@NotNull URI serverUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "shouldTryProxy"));
        }
        ServerConfiguration serverConfiguration = this.getConfiguration(serverUri);
        return serverConfiguration != null && serverConfiguration.getProxyUri() != null && !serverConfiguration.isProxyInaccessible();
    }

    public void setProxyInaccessible(@NotNull URI serverUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "setProxyInaccessible"));
        }
        this.getConfiguration(serverUri).setProxyInaccessible();
    }

    public void setProxyUri(@NotNull URI serverUri, @Nullable URI proxyUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "setProxyUri"));
        }
        String proxyUriString = proxyUri != null ? proxyUri.toString() : null;
        this.getOrCreateServerConfiguration(serverUri).setProxyUri(proxyUriString);
    }

    public synchronized void storeCredentials(@NotNull URI serverUri, @NotNull Credentials credentials) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "storeCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "storeCredentials"));
        }
        ServerConfiguration serverConfiguration = this.getOrCreateServerConfiguration(serverUri);
        serverConfiguration.setCredentials(credentials);
        final Notification notification = serverConfiguration.getAuthCanceledNotification();
        if (notification != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    notification.expire();
                }
            });
        }
        serverConfiguration.setAuthCanceledNotification(null);
    }

    public synchronized void resetStoredPasswords() {
        for (ServerConfiguration serverConfiguration : this.myServersConfig.values()) {
            Credentials credentials = serverConfiguration.getCredentials();
            if (credentials == null) continue;
            credentials.resetPassword();
        }
    }

    public void loadState(State state) {
        this.myServersConfig = state.config;
        this.myUseIdeaHttpProxy = state.useIdeaHttpProxy;
        this.mySupportTfsCheckinPolicies = state.supportTfsCheckinPolicies;
        this.mySupportStatefulCheckinPolicies = state.supportStatefulCheckinPolicies;
        this.myReportNotInstalledCheckinPolicies = state.reportNotInstalledCheckinPolicies;
    }

    public State getState() {
        State state = new State();
        state.config = this.myServersConfig;
        state.supportStatefulCheckinPolicies = this.mySupportStatefulCheckinPolicies;
        state.supportTfsCheckinPolicies = this.mySupportTfsCheckinPolicies;
        state.useIdeaHttpProxy = this.myUseIdeaHttpProxy;
        state.reportNotInstalledCheckinPolicies = this.myReportNotInstalledCheckinPolicies;
        return state;
    }

    private static String getConfigKey(URI serverUri) {
        String uriString = serverUri.toString();
        if (!uriString.endsWith("/")) {
            uriString = uriString + "/";
        }
        return uriString;
    }

    @Nullable
    private ServerConfiguration getConfiguration(URI serverUri) {
        return this.myServersConfig.get(TFSConfigurationManager.getConfigKey(serverUri));
    }

    @NotNull
    private ServerConfiguration getOrCreateServerConfiguration(@NotNull URI serverUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "getOrCreateServerConfiguration"));
        }
        ServerConfiguration config = this.myServersConfig.get(TFSConfigurationManager.getConfigKey(serverUri));
        if (config == null) {
            config = new ServerConfiguration();
            this.myServersConfig.put(TFSConfigurationManager.getConfigKey(serverUri), config);
        }
        ServerConfiguration serverConfiguration = config;
        if (serverConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "getOrCreateServerConfiguration"));
        }
        return serverConfiguration;
    }

    public boolean serverKnown(@NotNull String instanceId) {
        if (instanceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceId", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "serverKnown"));
        }
        for (ServerInfo server : Workstation.getInstance().getServers()) {
            if (!server.getGuid().equalsIgnoreCase(instanceId)) continue;
            return true;
        }
        return false;
    }

    public void remove(@NotNull URI serverUri) {
        if (serverUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUri", "org/jetbrains/tfsIntegration/core/configuration/TFSConfigurationManager", "remove"));
        }
        final ServerConfiguration config = this.myServersConfig.get(TFSConfigurationManager.getConfigKey(serverUri));
        if (config != null && config.getAuthCanceledNotification() != null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    config.getAuthCanceledNotification().expire();
                }
            });
        }
        this.myServersConfig.remove(TFSConfigurationManager.getConfigKey(serverUri));
    }

    public void setUseIdeaHttpProxy(boolean useIdeaHttpProxy) {
        this.myUseIdeaHttpProxy = useIdeaHttpProxy;
    }

    public boolean useIdeaHttpProxy() {
        return this.myUseIdeaHttpProxy;
    }

    public TfsCheckinPoliciesCompatibility getCheckinPoliciesCompatibility() {
        return new TfsCheckinPoliciesCompatibility(this.mySupportStatefulCheckinPolicies, this.mySupportTfsCheckinPolicies, this.myReportNotInstalledCheckinPolicies);
    }

    public void setSupportTfsCheckinPolicies(boolean supportTfsCheckinPolicies) {
        this.mySupportTfsCheckinPolicies = supportTfsCheckinPolicies;
    }

    public void setSupportStatefulCheckinPolicies(boolean supportStatefulCheckinPolicies) {
        this.mySupportStatefulCheckinPolicies = supportStatefulCheckinPolicies;
    }

    public void setReportNotInstalledCheckinPolicies(boolean reportNotInstalledCheckinPolicies) {
        this.myReportNotInstalledCheckinPolicies = reportNotInstalledCheckinPolicies;
    }

    public static class State {
        @MapAnnotation(entryTagName="server", keyAttributeName="uri", surroundValueWithTag=false)
        public Map<String, ServerConfiguration> config = new HashMap<String, ServerConfiguration>();
        public boolean useIdeaHttpProxy = true;
        public boolean supportTfsCheckinPolicies = true;
        public boolean supportStatefulCheckinPolicies = true;
        public boolean reportNotInstalledCheckinPolicies = true;
    }
}

