/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs.labels;

import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LabelItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionSpec;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.labels.ItemAndVersion;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;

public class LabelItemSpecWithItems {
    private final LabelItemSpec myLabelItemSpec;
    private final List<Item> myItemsList;

    private LabelItemSpecWithItems(@NotNull LabelItemSpec labelItemSpec, @NotNull List<Item> itemsList) {
        if (labelItemSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelItemSpec", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems", "<init>"));
        }
        if (itemsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemsList", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems", "<init>"));
        }
        this.myLabelItemSpec = labelItemSpec;
        this.myItemsList = itemsList;
    }

    public static LabelItemSpecWithItems createForAdd(@NotNull ItemSpec item, @NotNull VersionSpecBase version, @NotNull List<Item> itemsList) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems", "createForAdd"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems", "createForAdd"));
        }
        if (itemsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemsList", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems", "createForAdd"));
        }
        LabelItemSpec labelItemSpec = new LabelItemSpec();
        labelItemSpec.setItemSpec(item);
        labelItemSpec.setVersion((VersionSpec)version);
        labelItemSpec.setEx(false);
        return new LabelItemSpecWithItems(labelItemSpec, itemsList);
    }

    public static LabelItemSpecWithItems createForRemove(@NotNull ItemAndVersion item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/tfsIntegration/core/tfs/labels/LabelItemSpecWithItems", "createForRemove"));
        }
        ItemSpec itemSpec = VersionControlServer.createItemSpec(item.getItem().getItem(), (RecursionType)(item.getItem().getType() == ItemType.Folder ? RecursionType.Full : null));
        LabelItemSpec labelItemSpec = new LabelItemSpec();
        labelItemSpec.setEx(true);
        labelItemSpec.setItemSpec(itemSpec);
        labelItemSpec.setVersion(item.getVersionSpec());
        return new LabelItemSpecWithItems(labelItemSpec, Collections.<Item>emptyList());
    }

    public LabelItemSpec getLabelItemSpec() {
        return this.myLabelItemSpec;
    }

    public List<Item> getItemsList() {
        return this.myItemsList;
    }

    public String getServerPath() {
        return this.getLabelItemSpec().getItemSpec().getItem();
    }
}

