/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.VersionControlLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.LabelsTableModel;
import org.jetbrains.tfsIntegration.ui.SelectLabelDialog;

public class SelectLabelForm {
    private JTextField myNameField;
    private JTextField myOwnerField;
    private JButton myFindButton;
    private JTable myLabelsTable;
    private JPanel myContentPane;
    private final LabelsTableModel myLabelsTableModel;
    private final EventDispatcher<Listener> myEventDispatcher;

    public SelectLabelForm(final SelectLabelDialog dialog, final WorkspaceInfo workspace) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myLabelsTableModel = new LabelsTableModel();
        this.myLabelsTable.setModel(this.myLabelsTableModel);
        this.myLabelsTable.setSelectionMode(0);
        this.myLabelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ((Listener)SelectLabelForm.this.myEventDispatcher.getMulticaster()).selectionChanged();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (SelectLabelForm.this.isLabelSelected()) {
                    dialog.close(0);
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myLabelsTable);
        this.myFindButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String name;
                    String owner = SelectLabelForm.this.myOwnerField.getText().trim();
                    if ("".equals(owner)) {
                        owner = null;
                    }
                    if ("".equals(name = SelectLabelForm.this.myNameField.getText().trim())) {
                        name = null;
                    }
                    List<VersionControlLabel> labels = workspace.getServer().getVCS().queryLabels(name, "$/", owner, false, null, null, false, SelectLabelForm.this.getContentPane(), TFSBundle.message("searching.for.label", new Object[0]));
                    SelectLabelForm.this.myLabelsTableModel.setLabels(labels);
                }
                catch (TfsException ex) {
                    SelectLabelForm.this.myLabelsTableModel.setLabels(Collections.<VersionControlLabel>emptyList());
                    Messages.showErrorDialog((Component)SelectLabelForm.this.myContentPane, (String)ex.getMessage(), (String)"Find Label");
                }
                finally {
                    ((Listener)SelectLabelForm.this.myEventDispatcher.getMulticaster()).selectionChanged();
                }
            }
        });
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    public boolean isLabelSelected() {
        return this.myLabelsTable.getSelectedRowCount() == 1;
    }

    @NotNull
    public VersionControlLabel getLabel() {
        VersionControlLabel versionControlLabel = this.myLabelsTableModel.getLabels().get(this.myLabelsTable.getSelectedRow());
        if (versionControlLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SelectLabelForm", "getLabel"));
        }
        return versionControlLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Options", (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Owner:");
        jLabel2.setDisplayedMnemonic('O');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOwnerField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFindButton = jButton = new JButton();
        jButton.setText("Find");
        jButton.setMnemonic('F');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = new JBTable();
        this.myLabelsTable = jBTable;
        jBScrollPane.setViewportView((Component)jBTable);
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("R&esults");
        jPanel.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        titledSeparator.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends EventListener {
        public void selectionChanged();
    }
}

