/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.AdminProtocol;
import org.w3c.jigsaw.admin.AdminProtocolException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.jigsaw.admin.RemoteResourceFactory;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.serialization.ResourceDescription;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;

class AdminReader
implements AdminProtocol {
    RemoteResourceFactory factory = null;
    protected AdminContext admin = null;
    protected static Serializer serializer = null;

    protected RemoteResource readResource(URL uRL, String string, InputStream inputStream) throws IOException, AdminProtocolException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ResourceDescription[] resourceDescriptionArray = serializer.readResourceDescriptions(bufferedReader);
            if (resourceDescriptionArray.length < 1) {
                throw new AdminProtocolException("Unknown resource");
            }
            return this.factory.createRemoteResource(uRL, string, resourceDescriptionArray[0]);
        }
        catch (SerializationException serializationException) {
            throw new AdminProtocolException("Error in serialized resource :" + serializationException.getMessage());
        }
    }

    public static Resource readResource(InputStream inputStream) throws IOException, AdminProtocolException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Resource[] resourceArray = serializer.readResources(bufferedReader);
            if (resourceArray.length < 1) {
                throw new AdminProtocolException("No resource found.");
            }
            return resourceArray[0];
        }
        catch (SerializationException serializationException) {
            throw new AdminProtocolException("Error in serialized resource :" + serializationException.getMessage());
        }
    }

    public static ResourceDescription readResourceDescription(InputStream inputStream) throws IOException, AdminProtocolException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            ResourceDescription[] resourceDescriptionArray = serializer.readResourceDescriptions(bufferedReader);
            if (resourceDescriptionArray.length < 1) {
                throw new AdminProtocolException("No resource found.");
            }
            return resourceDescriptionArray[0];
        }
        catch (SerializationException serializationException) {
            throw new AdminProtocolException("Error in serialized resource :" + serializationException.getMessage());
        }
    }

    AdminReader(AdminContext adminContext) {
        this.admin = adminContext;
        this.factory = new RemoteResourceFactory(adminContext);
    }

    static {
        serializer = new XMLSerializer();
    }
}

