/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.agent.ReflectiveThreadAgentProxyFactory;
import com.intellij.javaee.oss.geronimo.admin.Geronimo10AdminServerImpl;
import com.intellij.javaee.oss.geronimo.admin.Geronimo11AdminServerImpl;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.Version;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;

abstract class GeronimoServerModel
extends JavaeeServerModel {
    @NonNls
    private static final String GERONIMO_LOG_FILE_ID = "Geronimo";

    GeronimoServerModel() {
    }

    protected String getLogFileId() {
        return GERONIMO_LOG_FILE_ID;
    }

    @NonNls
    protected String getDefaultUsername() {
        return "system";
    }

    @NonNls
    protected String getDefaultPassword() {
        return "manager";
    }

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        Version version = new Version(this.getVersion());
        if (version.getMajor() == 1 && version.getMinor() == 0) {
            return new Geronimo10AdminServerImpl((AgentProxyFactory)new ReflectiveThreadAgentProxyFactory(), this.getLibraries());
        }
        if (version.getMajor() >= 3) {
            return new Geronimo11AdminServerImpl((AgentProxyFactory)new ProcessAgentProxyFactory(serverInstance), this.getLibraries());
        }
        return new Geronimo11AdminServerImpl((AgentProxyFactory)new ReflectiveThreadAgentProxyFactory(), this.getLibraries());
    }

    protected List<File> getLibraries() {
        List libraries = super.getLibraries();
        libraries.add(this.getPathUnderHome("lib"));
        libraries.add(this.getPathUnderHome("repository/org/apache/geronimo/specs"));
        libraries.add(this.getPathUnderHome("repository/org/apache/geronimo/modules"));
        libraries.add(this.getPathUnderHome("repository/org/apache/geronimo/framework"));
        libraries.add(this.getPathUnderHome("jsr88"));
        libraries.add(this.getPathUnderHome("repository/org/ops4j/pax/logging"));
        return libraries;
    }
}

