/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.shell.GroovyShellConfig;

public class GrailsShellConfig
extends GroovyShellConfig {
    @NotNull
    public String getWorkingDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/GrailsShellConfig", "getWorkingDirectory"));
        }
        VirtualFile appRoot = GrailsFramework.getInstance().findAppRoot(module);
        assert (appRoot != null);
        String string = appRoot.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/GrailsShellConfig", "getWorkingDirectory"));
        }
        return string;
    }

    @NotNull
    public JavaParameters createJavaParameters(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/GrailsShellConfig", "createJavaParameters"));
        }
        GrailsCommandExecutor executor = GrailsUtils.getGrailsExecutor(module);
        assert (executor != null);
        JavaParameters javaParameters = executor.createJavaParameters(module, false, null, "shell");
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/GrailsShellConfig", "createJavaParameters"));
        }
        return javaParameters;
    }

    public boolean canRun(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/GrailsShellConfig", "canRun"));
        }
        return GrailsFramework.getInstance().hasSupport(module);
    }

    public PsiElement getContext(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/GrailsShellConfig", "getContext"));
        }
        GroovyFile file = GroovyPsiElementFactory.getInstance((Project)module.getProject()).createGroovyFile((CharSequence)"class DummyClass { org.codehaus.groovy.grails.commons.spring.GrailsWebApplicationContext ctx = null; org.codehaus.groovy.grails.commons.GrailsApplication grailsApplication = null;\n}", false, null);
        file.putUserData(ModuleUtilCore.KEY_MODULE, (Object)module);
        return file.getClasses()[0];
    }

    public String getTitle() {
        return "Grails Shell";
    }

    @NotNull
    public String getVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/GrailsShellConfig", "getVersion"));
        }
        if ("Grails" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/GrailsShellConfig", "getVersion"));
        }
        return "Grails";
    }
}

