/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import icons.GroovyMvcIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.actions.NewGroovyActionBase;

public class NewGspAction
extends NewGroovyActionBase {
    private static final String POINT_GSP = ".gsp";

    public NewGspAction() {
        super(GrailsBundle.message("gsp.menu.action.text", new Object[0]), GrailsBundle.message("gsp.menu.action.description", new Object[0]), GroovyMvcIcons.Gsp_logo);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return null;
    }

    protected String getDialogPrompt() {
        return GrailsBundle.message("gsp.dlg.prompt", new Object[0]);
    }

    protected String getDialogTitle() {
        return GrailsBundle.message("gsp.dlg.title", new Object[0]);
    }

    protected String getCommandName() {
        return GrailsBundle.message("gsp.command.name", new Object[0]);
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && NewGspAction.isInWebAppOrGrailsViewsDirectory(dataContext);
    }

    public void update(AnActionEvent e) {
        IdeView view;
        Presentation presentation = e.getPresentation();
        super.update(e);
        if (presentation.isEnabled() && (view = (IdeView)e.getData(DataKeys.IDE_VIEW)) != null) {
            for (PsiDirectory dir : view.getDirectories()) {
                if (!GrailsUtils.isUnderGrailsViewsDirectory(dir)) continue;
                presentation.setWeight(42.0);
                return;
            }
        }
    }

    private static boolean isInWebAppOrGrailsViewsDirectory(DataContext dataContext) {
        IdeView view = (IdeView)DataKeys.IDE_VIEW.getData(dataContext);
        Module module = (Module)DataKeys.MODULE.getData(dataContext);
        if (module == null || !GrailsUtils.hasSupport(module)) {
            return false;
        }
        if (view != null) {
            for (PsiDirectory dir : view.getDirectories()) {
                if (!GrailsUtils.isUnderWebAppDirectory(dir) && !GrailsUtils.isUnderGrailsViewsDirectory(dir)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected PsiElement[] doCreate(String newName, PsiDirectory directory) throws Exception {
        String templateName = "GroovyServerPage.gsp";
        if (newName.endsWith(POINT_GSP)) {
            newName = newName.substring(0, newName.length() - POINT_GSP.length());
        }
        PsiFile psiFile = newName.startsWith("_") ? directory.createFile(newName + POINT_GSP) : GroovyTemplatesFactory.createFromTemplate((PsiDirectory)directory, (String)newName, (String)(newName + POINT_GSP), (String)templateName, (boolean)true, (String[])new String[0]);
        PsiElement[] psiElementArray = new PsiElement[]{psiFile};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/actions/NewGspAction", "doCreate"));
        }
        return psiElementArray;
    }
}

