/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.GroovyMvcIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.Grails3OptionsWizardStep;
import org.jetbrains.plugins.groovy.grails.Grails3InstallationCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;

public class Grails3ModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(Grails3ModuleBuilder.class);
    private ProjectData myParentProject;
    private String myGrailsSDKHome;
    private boolean isCreatingNewProject;

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        if (this.doAddContentEntry(modifiableRootModel) == null) {
            throw new ConfigurationException("Cannot setup root path");
        }
    }

    protected void setupModule(final Module module) throws ConfigurationException {
        super.setupModule(module);
        final Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                try {
                    Grails3ModuleBuilder.this.doSetupModule(module);
                }
                catch (ExecutionException e) {
                    MvcConsole.NOTIFICATION_GROUP.createNotification("Failed to create Grails app structure", e.getMessage(), NotificationType.WARNING, null).notify(project);
                }
            }
        });
    }

    private void doSetupModule(final Module module) throws ExecutionException {
        final Project project = module.getProject();
        PropertiesComponent.getInstance((Project)project).setValue("grails.sdk.home", this.myGrailsSDKHome);
        final VirtualFile rootModuleContent = Grails3ModuleBuilder.getModuleRoot(module);
        final String rootProjectPath = this.getProjectRootPath(module, rootModuleContent);
        GeneralCommandLine parameters = Grails3ModuleBuilder.createParameters(module, rootModuleContent);
        final boolean fresh = this.isCreatingNewProject || this.myParentProject == null;
        MvcConsole.executeProcess((Module)module, (GeneralCommandLine)parameters, (Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.debug("Grails application structure created for module: " + module);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GradleModuleBuilder.setupGradleSettingsFile((String)rootProjectPath, (VirtualFile)rootModuleContent, (String)module.getProject().getName(), (String)module.getName(), (boolean)fresh);
                            LOG.debug("'settings.gradle' file set up for module: " + module);
                        }
                        catch (ConfigurationException e) {
                            LOG.debug((Throwable)e);
                            MvcConsole.NOTIFICATION_GROUP.createNotification("Failed to create settings.gradle", e.getMessage(), NotificationType.WARNING, null).notify(project);
                        }
                    }
                });
                Grails3ModuleBuilder.this.linkProject(fresh, rootProjectPath, project);
            }
        }, (boolean)true, (String[])new String[0]);
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new Grails3OptionsWizardStep(context, this);
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return "Grails 3";
    }

    public String getDescription() {
        return "Grails 3 application module builder";
    }

    public Icon getNodeIcon() {
        return GroovyMvcIcons.Grails;
    }

    public String getParentGroup() {
        return "Groovy";
    }

    public Grails3ModuleBuilder setParentProject(ProjectData parentProject) {
        this.myParentProject = parentProject;
        return this;
    }

    public Grails3ModuleBuilder setGrailsSDKHome(String grailsSDKHome) {
        this.myGrailsSDKHome = grailsSDKHome;
        return this;
    }

    public Grails3ModuleBuilder setCreatingNewProject(boolean creatingNewProject) {
        this.isCreatingNewProject = creatingNewProject;
        return this;
    }

    private static VirtualFile getModuleRoot(Module module) {
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        assert (roots.length == 1);
        return roots[0];
    }

    @NotNull
    private String getProjectRootPath(Module module, VirtualFile rootModuleContent) {
        String result = this.myParentProject == null ? FileUtil.toCanonicalPath((String)(this.isCreatingNewProject ? module.getProject().getBasePath() : rootModuleContent.getPath())) : this.myParentProject.getLinkedExternalProjectPath();
        assert (result != null);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/Grails3ModuleBuilder", "getProjectRootPath"));
        }
        return string;
    }

    @NotNull
    private static GeneralCommandLine createParameters(Module module, VirtualFile rootModuleContent) throws ExecutionException {
        JavaParameters params = Grails3InstallationCommandExecutor.createJavaParametersInner(module, new MvcCommand("create-app", new String[]{"--inplace"}));
        params.setWorkingDirectory(rootModuleContent.getPath());
        GeneralCommandLine parameters = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)params);
        LOG.debug(parameters.getCommandLineString());
        GeneralCommandLine generalCommandLine = parameters;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/Grails3ModuleBuilder", "createParameters"));
        }
        return generalCommandLine;
    }

    private void linkProject(boolean fresh, String rootProjectPath, Project project) {
        GradleProjectSettings gradleSettings = new GradleProjectSettings();
        gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        if (this.isCreatingNewProject) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        if (fresh) {
            gradleSettings.setExternalProjectPath(rootProjectPath);
            ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)gradleSettings);
            LOG.debug("Project '" + project + "' linked with " + gradleSettings);
        }
        if (!this.isCreatingNewProject) {
            FileDocumentManager.getInstance().saveAllDocuments();
            LOG.debug("Starting refreshing the project: " + rootProjectPath);
        }
        ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)rootProjectPath, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }
}

