/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.VersionComparatorUtil;
import icons.GroovyMvcIcons;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;

public class GrailsModuleStructureUtil {
    @NonNls
    private static final String INPLACE_PLUGINS_MODULE_SUFFIX = "-inplacePlugin";
    @NonNls
    private static final String INPLACE_PLUGINS_MODULE_INFIX_OLD = "-grailsPlugin-";
    @NonNls
    static final String GRAILS_VERSION_KEY = "app.grails.version";
    @NonNls
    static final String UPGRADE_COMMAND = "upgrade";
    @NonNls
    static final String UPGRADE_COMMAND_2_4_x = "set-grails-version";
    @NonNls
    static final String YES = "y\n";
    @NonNls
    static final String YESx2 = "y\ny\n";

    private GrailsModuleStructureUtil() {
    }

    public static Set<Module> getAllCustomPluginModules(Module module) {
        HashSet<Module> res = new HashSet<Module>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        GrailsModuleStructureUtil.collectCustomPluginModules(module, res, fileIndex);
        res.remove(module);
        return res;
    }

    private static void collectCustomPluginModules(Module module, Set<Module> result, ProjectFileIndex fileIndex) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!result.add(module)) {
            return;
        }
        Map<String, VirtualFile> locations = GrailsFramework.getCustomPluginLocations(module, true);
        for (VirtualFile virtualFile : locations.values()) {
            Module candidate = fileIndex.getModuleForFile(virtualFile);
            if (candidate == null || !Comparing.equal((Object)fileIndex.getContentRootForFile(virtualFile), (Object)virtualFile) || !GrailsFramework.getInstance().hasSupport(module)) continue;
            GrailsModuleStructureUtil.collectCustomPluginModules(candidate, result, fileIndex);
        }
    }

    static void upgradeGrails(Module module) {
        GeneralCommandLine commandLine;
        int result;
        String appVersion;
        GrailsFramework framework = GrailsFramework.getInstance();
        String libVersion = GrailsConfigUtils.getGrailsVersion(module);
        if (libVersion == null || "undefined".equals(libVersion)) {
            return;
        }
        if (Comparing.equal((String)((String)module.getUserData(MvcModuleStructureUtil.LAST_MVC_VERSION)), (String)libVersion)) {
            return;
        }
        PropertiesFile file = MvcModuleStructureUtil.findApplicationProperties((Module)module, (MvcFramework)framework);
        IProperty property = file == null ? null : file.findPropertyByKey(GRAILS_VERSION_KEY);
        String string = appVersion = property == null ? null : property.getValue();
        if (StringUtil.isEmptyOrSpaces((String)appVersion)) {
            return;
        }
        if (appVersion.equals(libVersion)) {
            return;
        }
        GrailsSettings grailsSettings = GrailsSettingsService.getGrailsSettings(module);
        if (appVersion.equals(grailsSettings.fixedGrailsVersion)) {
            return;
        }
        boolean ask = module.getUserData(MvcFramework.UPGRADE) != Boolean.TRUE;
        module.putUserData(MvcFramework.UPGRADE, null);
        module.putUserData(MvcModuleStructureUtil.LAST_MVC_VERSION, (Object)libVersion);
        if (ask && (result = Messages.showDialog((String)GrailsBundle.message("grails.malformed.version", appVersion, libVersion, module.getName()), (String)GrailsBundle.message("grails.upgrade.app", new Object[0]), (String[])new String[]{"Yes, upgrade", "Not now", "No, don't ask for this module"}, (int)0, (Icon)GroovyMvcIcons.Grails_module)) != 0) {
            if (result == 2) {
                grailsSettings.fixedGrailsVersion = appVersion;
            }
            return;
        }
        GeneralCommandLine generalCommandLine = commandLine = VersionComparatorUtil.compare((String)libVersion, (String)"2.4.0") >= 0 ? framework.createCommandAndShowErrors(module, UPGRADE_COMMAND_2_4_x, new String[]{libVersion}) : framework.createCommandAndShowErrors(module, UPGRADE_COMMAND, new String[0]);
        if (commandLine == null) {
            return;
        }
        MvcConsole.executeProcess((Module)module, (GeneralCommandLine)commandLine, null, (boolean)true, (String[])new String[]{YESx2});
    }

    public static boolean isIdeaGeneratedCustomPluginModule(Module pluginModule) {
        String name = pluginModule.getName();
        return name.endsWith(INPLACE_PLUGINS_MODULE_SUFFIX) || name.contains(INPLACE_PLUGINS_MODULE_INFIX_OLD);
    }

    public static String generateInplacePluginModuleName(String pluginName) {
        return pluginName + INPLACE_PLUGINS_MODULE_SUFFIX;
    }

    public static boolean isInplacePluginModuleName(@NotNull String pluginName) {
        if (pluginName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginName", "org/jetbrains/plugins/grails/config/GrailsModuleStructureUtil", "isInplacePluginModuleName"));
        }
        return pluginName.endsWith(INPLACE_PLUGINS_MODULE_SUFFIX);
    }
}

