/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;

public class GrailsSettingSynchronizer {
    private static final Logger LOG = Logger.getInstance(GrailsSettingSynchronizer.class);
    private static final String PRINT_SCRIPT_NAME = "IdeaPrintProjectSettings.groovy";
    private static final String SCRIPT_DIRECTORY = ".grails/scripts";
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([A-Za-z]+)\\.\\d+");
    private static final String SYNCHRONIZATION_COMPLETED_MESSAGE = "Settings synchronization completed";
    private static final Pattern ARTIFACT_TYPE_PATTERN = Pattern.compile(".+/([^/]+)/(?:sources|javadocs)/\\1-[^/]+-(javadoc|sources)\\.jar\\!/");
    private static final Pattern IVY_JAR_PATTERN = Pattern.compile("(.+)/([^/]+)/jars/\\2-([^/]+)\\.jar\\!/");
    private static final Pattern MAVEN_JAR_PATTERN = Pattern.compile("(.+)/([^/]+)/([^/]+)/\\2-\\3\\.jar\\!/");
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Grails", (String)"Console");
    protected final Module myModule;
    private static final Set<Module> myCurrentUpdatingSettings = new HashSet<Module>();

    public GrailsSettingSynchronizer(Module module) {
        this.myModule = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateSettingRunning() {
        Set<Module> set = myCurrentUpdatingSettings;
        synchronized (set) {
            Iterator<Module> itr = myCurrentUpdatingSettings.iterator();
            while (itr.hasNext()) {
                Module module = itr.next();
                if (!module.isDisposed()) continue;
                itr.remove();
            }
            return !myCurrentUpdatingSettings.isEmpty();
        }
    }

    protected void onDone(boolean isSettingChanged, boolean isExtractingSettingsRan) {
        VirtualFile buildConfigFile;
        if (isSettingChanged && (buildConfigFile = this.getBuildConfigFile()) != null) {
            EditorNotifications.getInstance((Project)this.myModule.getProject()).updateNotifications(buildConfigFile);
        }
    }

    @Nullable
    private String getBuildConfigText() {
        VirtualFile buildConfigFile = this.getBuildConfigFile();
        if (buildConfigFile != null) {
            try {
                return VfsUtilCore.loadText((VirtualFile)buildConfigFile);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private VirtualFile getBuildConfigFile() {
        VirtualFile appDirectory = GrailsFramework.getInstance().findAppDirectory(this.myModule);
        assert (appDirectory != null);
        return VfsUtil.findRelativeFile((VirtualFile)appDirectory, (String[])new String[]{"conf", "BuildConfig.groovy"});
    }

    private void showMessage(String message, MessageType type) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MvcConsole.getInstance((Project)this.myModule.getProject());
        NOTIFICATION_GROUP.createNotification(message, type).notify(this.myModule.getProject());
    }

    private static String readJvmOptions(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingSynchronizer", "readJvmOptions"));
        }
        VirtualFile root = GrailsUtils.findGrailsAppRoot(module);
        if (root == null) {
            return null;
        }
        VirtualFile vmOptionFile = root.findChild("grails-synch-jvm-options.txt");
        if (vmOptionFile == null) {
            return null;
        }
        return LoadTextUtil.loadText((VirtualFile)vmOptionFile).toString().replaceAll("\\s*\\n\\s*", " ").trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncGrailsSettings(final boolean isCalledByUser) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            GeneralCommandLine commandLine;
            GrailsSettings settings = GrailsSettingsService.getGrailsSettings(this.myModule);
            String buildConfigText = this.getBuildConfigText();
            int pluginDependenciesCrc = GrailsUtils.getPluginDependenciesCrc(this.myModule);
            if (buildConfigText == null && pluginDependenciesCrc == 0) {
                boolean isChanged;
                if (settings.buildConfigCrc != null && settings.buildConfigCrc == 0 && settings.pluginDependenciesCrc == 0 && settings.properties.isEmpty() && settings.customPluginLocations.isEmpty()) {
                    isChanged = false;
                } else {
                    AccessToken token = WriteAction.start();
                    try {
                        settings.buildConfigCrc = 0;
                        settings.pluginDependenciesCrc = 0;
                        settings.customPluginLocations.clear();
                        settings.properties.clear();
                    }
                    finally {
                        token.finish();
                    }
                    isChanged = true;
                }
                if (isChanged || isCalledByUser) {
                    this.showMessage(SYNCHRONIZATION_COMPLETED_MESSAGE, MessageType.INFO);
                }
                this.onDone(isChanged, false);
                boolean token = true;
                return token;
            }
            if (!isCalledByUser && !settings.isBuildConfigOutdated(buildConfigText) && settings.pluginDependenciesCrc == pluginDependenciesCrc) {
                this.onDone(false, false);
                boolean isChanged = true;
                return isChanged;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                boolean isChanged = true;
                return isChanged;
            }
            if (!GrailsSettingSynchronizer.ensureScriptExists(PRINT_SCRIPT_NAME, SCRIPT_DIRECTORY)) {
                boolean isChanged = false;
                return isChanged;
            }
            GrailsCommandExecutor commandExecutor = GrailsUtils.getGrailsExecutor(this.myModule);
            if (commandExecutor == null) {
                boolean bl = false;
                return bl;
            }
            try {
                MvcCommand command = MvcCommand.parse((String)"idea-print-project-settings", (String)GrailsSettingSynchronizer.readJvmOptions(this.myModule));
                JavaParameters params = commandExecutor.createJavaParameters(this.myModule, false, command);
                MvcFramework.addJavaHome((JavaParameters)params, (Module)this.myModule);
                VirtualFile grailsHome = GrailsFramework.getInstance().getSdkRoot(this.myModule);
                if (grailsHome != null) {
                    params.addEnv(GrailsFramework.getInstance().getSdkHomePropertyName(), FileUtil.toSystemDependentName((String)grailsHome.getPath()));
                }
                commandLine = MvcFramework.createCommandLine((JavaParameters)params);
            }
            catch (ExecutionException e) {
                Notifications.Bus.notify((Notification)new Notification("grails", "Failed to run grails command", e.getMessage(), NotificationType.ERROR));
                boolean command = false;
                return command;
            }
            final StringBuilder output = new StringBuilder();
            ProcessAdapter listener = new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output.append(StringUtil.convertLineSeparators((String)event.getText()));
                    }
                }
            };
            Set<Module> set = myCurrentUpdatingSettings;
            synchronized (set) {
                myCurrentUpdatingSettings.add(this.myModule);
            }
            MvcConsole.getInstance((Project)this.myModule.getProject()).executeProcess(this.myModule, commandLine, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set set = myCurrentUpdatingSettings;
                    synchronized (set) {
                        myCurrentUpdatingSettings.remove(GrailsSettingSynchronizer.this.myModule);
                    }
                    Ref isChanged = new Ref();
                    if (GrailsSettingSynchronizer.this.processOutput(GrailsSettingSynchronizer.this.myModule, output.toString(), (Ref<Boolean>)isChanged)) {
                        if (isCalledByUser || ((Boolean)isChanged.get()).booleanValue()) {
                            GrailsSettingSynchronizer.this.showMessage(GrailsSettingSynchronizer.SYNCHRONIZATION_COMPLETED_MESSAGE, MessageType.INFO);
                        }
                        GrailsSettingSynchronizer.this.onDone((Boolean)isChanged.get(), true);
                    } else {
                        GrailsSettingSynchronizer.this.showMessage("Settings synchronization failed", MessageType.ERROR);
                        MvcConsole.getInstance((Project)GrailsSettingSynchronizer.this.myModule.getProject()).show(null, true);
                    }
                    DaemonCodeAnalyzer.getInstance((Project)GrailsSettingSynchronizer.this.myModule.getProject()).restart();
                }
            }, isCalledByUser, true, new String[0]).addProcessListener((ProcessListener)listener);
            boolean bl = false;
            return bl;
        }
        finally {
            DaemonCodeAnalyzer.getInstance((Project)this.myModule.getProject()).restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureScriptExists(@NotNull String name, @NotNull String directory) {
        byte[] bundledScriptContents;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/config/GrailsSettingSynchronizer", "ensureScriptExists"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/plugins/grails/config/GrailsSettingSynchronizer", "ensureScriptExists"));
        }
        InputStream inputStream = GrailsSettingSynchronizer.class.getResourceAsStream("/" + name);
        try {
            try {
                bundledScriptContents = StreamUtil.loadFromStream((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            StreamUtil.closeStream((Closeable)inputStream);
        }
        File script = new File(String.format("%s/%s/%s", SystemProperties.getUserHome(), directory, name));
        if (!GrailsSettingSynchronizer.contentEquals(bundledScriptContents, script)) {
            try {
                FileUtil.writeToFile((File)script, (byte[])bundledScriptContents);
            }
            catch (Exception e) {
                Notifications.Bus.notify((Notification)new Notification("grails", "Grails Setting Synchronization failed", "Failed to create " + script.getPath() + ". See log for more details.", NotificationType.ERROR));
                LOG.warn("Failed to create " + script.getPath(), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean contentEquals(byte[] content, File file) {
        byte[] data = new byte[content.length];
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            try {
                in.readFully(data);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            return false;
        }
        return Arrays.equals(content, data);
    }

    private static List<VirtualFile> getPomFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsSettingSynchronizer", "getPomFiles"));
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        HashSet depentModules = new HashSet();
        ModuleUtil.getDependencies((Module)module, depentModules);
        for (Module m : depentModules) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)m).getContentRoots()) {
                ContainerUtil.addIfNotNull(result, (Object)root.findChild("pom.xml"));
            }
        }
        return result;
    }

    private static Set<String> getNonManagedJarNames(Module module) {
        THashSet coreJars = new THashSet();
        for (VirtualFile file : OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
            coreJars.add(PathUtil.getLocalFile((VirtualFile)file).getName());
        }
        Library defaultLibrary = MvcModuleStructureUtil.findUserLibrary((Module)module, (String)"Grails User Library");
        if (defaultLibrary != null) {
            for (VirtualFile file : defaultLibrary.getFiles(OrderRootType.CLASSES)) {
                coreJars.remove(PathUtil.getLocalFile((VirtualFile)file).getName());
            }
        }
        return coreJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOutput(Module module, String output, Ref<Boolean> isChanged) {
        if (!GrailsFramework.getInstance().hasSupport(this.myModule)) {
            return false;
        }
        MultiMap deps = new MultiMap();
        THashMap properties = new THashMap();
        THashMap customPluginLocations = new THashMap();
        if (!this.parseOutput((MultiMap<String, VirtualFile>)deps, (Map<String, String>)properties, (Map<String, String>)customPluginLocations, output)) {
            return false;
        }
        List<VirtualFile> dependenciesToPoms = GrailsSettingSynchronizer.getPomFiles(this.myModule);
        HashMap<VirtualFile, byte[]> contentCache = new HashMap<VirtualFile, byte[]>();
        Set<String> nonManagedJarNames = GrailsSettingSynchronizer.getNonManagedJarNames(this.myModule);
        Iterator itr = deps.values().iterator();
        block3: while (itr.hasNext()) {
            String path;
            VirtualFile virtualFile = (VirtualFile)itr.next();
            if (nonManagedJarNames.contains(virtualFile.getName())) {
                itr.remove();
                continue;
            }
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
            if (jar == null || !(path = jar.getPath()).endsWith(".jar")) continue;
            String pomPath = path.substring(0, path.length() - ".jar".length()) + ".pom";
            VirtualFile pom = LocalFileSystem.getInstance().refreshAndFindFileByPath(pomPath);
            if (pom == null) {
                VirtualFile artifactDir;
                VirtualFile jarDir = jar.getParent();
                if (jarDir != null && "jars".equals(jarDir.getName()) && (artifactDir = jarDir.getParent()) != null) {
                    String artifactName = artifactDir.getName();
                    String jarName = jar.getName();
                    if (jarName.startsWith(artifactName) && jarName.length() > artifactName.length() + ".jar".length()) {
                        String version = jarName.substring(artifactName.length(), jarName.length() - ".jar".length());
                        pom = artifactDir.findChild("ivy" + version + ".xml.original");
                    }
                }
                if (pom == null) continue;
            }
            for (VirtualFile dependPom : dependenciesToPoms) {
                if (!GrailsSettingSynchronizer.equalsByContent(pom, dependPom, contentCache)) continue;
                itr.remove();
                continue block3;
            }
        }
        LinkedHashSet<VirtualFile> compileDeps = new LinkedHashSet<VirtualFile>(deps.get((Object)"Compile"));
        compileDeps.addAll(deps.get((Object)"Runtime"));
        compileDeps.addAll(deps.get((Object)"Test"));
        compileDeps.addAll(deps.get((Object)"Build"));
        compileDeps.addAll(deps.get((Object)"Provided"));
        GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
        String buildConfigText = this.getBuildConfigText();
        int pluginDependenciesCrc = GrailsUtils.getPluginDependenciesCrc(module);
        isChanged.set((Object)(!properties.equals(settings.properties) || !customPluginLocations.equals(settings.customPluginLocations) ? 1 : 0));
        AccessToken token = WriteAction.start();
        try {
            MvcFramework framework = MvcFramework.getInstance((Module)module);
            if (framework != null) {
                settings.properties = properties;
                settings.customPluginLocations = customPluginLocations;
                settings.updateBuildConfig(buildConfigText);
                settings.pluginDependenciesCrc = pluginDependenciesCrc;
                GrailsSettingSynchronizer.applyDefaultLibraryChanges(module, compileDeps);
            }
        }
        finally {
            token.finish();
        }
        return true;
    }

    private static boolean equalsByContent(VirtualFile file1, VirtualFile file2, Map<VirtualFile, byte[]> contentCache) {
        if (file1.getLength() != file2.getLength()) {
            return false;
        }
        try {
            return Arrays.equals(GrailsSettingSynchronizer.getContent(file1, contentCache), GrailsSettingSynchronizer.getContent(file2, contentCache));
        }
        catch (IOException e) {
            LOG.warn("Failed to read file", (Throwable)e);
            return false;
        }
    }

    private static byte[] getContent(VirtualFile file, Map<VirtualFile, byte[]> contentCache) throws IOException {
        byte[] res = contentCache.get(file);
        if (res == null) {
            res = file.contentsToByteArray();
            contentCache.put(file, res);
        }
        return res;
    }

    private boolean parseOutput(MultiMap<String, VirtualFile> deps, Map<String, String> properties, Map<String, String> customPlugins, String output) {
        int startIndex = output.indexOf("---=== IDEA Grails build settings ===---");
        if (startIndex == -1) {
            return false;
        }
        int endIndex = output.indexOf("---=== End IDEA Grails build settings ===---");
        if (endIndex < startIndex) {
            return false;
        }
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(output.substring(startIndex + "---=== IDEA Grails build settings ===---".length(), endIndex).getBytes()));
        }
        catch (IOException e) {
            return false;
        }
        if (props.isEmpty()) {
            return false;
        }
        VirtualFile appRoot = null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("grails.plugin.location.")) {
                customPlugins.put(key.substring("grails.plugin.location.".length()), value);
                continue;
            }
            Matcher matcher = DEPENDENCY_PATTERN.matcher(key);
            if (matcher.matches()) {
                VirtualFile dependency;
                String systemIndependentPath = FileUtil.toSystemIndependentName((String)value);
                if (!new File(systemIndependentPath).isAbsolute()) {
                    if (appRoot == null) {
                        appRoot = GrailsFramework.getInstance().findAppRoot(this.myModule);
                    }
                    if (appRoot != null) {
                        systemIndependentPath = appRoot.getPath() + '/' + systemIndependentPath;
                    }
                }
                if ((dependency = LocalFileSystem.getInstance().refreshAndFindFileByPath(systemIndependentPath)) == null) continue;
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(dependency);
                VirtualFile toAdd = jarRoot != null ? jarRoot : dependency;
                deps.putValue((Object)matcher.group(1), (Object)toAdd);
                continue;
            }
            properties.put(key, value);
        }
        return true;
    }

    private static OrderRootType getArtifactType(String url) {
        Matcher matcher = ARTIFACT_TYPE_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return OrderRootType.CLASSES;
        }
        String type = matcher.group(2);
        if (type.equals("sources")) {
            return OrderRootType.SOURCES;
        }
        assert (type.equals("javadoc"));
        return JavadocOrderRootType.getInstance();
    }

    private static void applyDefaultLibraryChanges(Module module, Set<VirtualFile> compileDeps) {
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        Library.ModifiableModel modifiableModel = MvcModuleStructureUtil.modifyDefaultLibrary((ModifiableRootModel)model, (String)"Grails User Library");
        HashSet<VirtualFile> exists = new HashSet<VirtualFile>();
        for (VirtualFile file : modifiableModel.getFiles(OrderRootType.CLASSES)) {
            if (!compileDeps.contains(file) || OrderRootType.CLASSES != GrailsSettingSynchronizer.getArtifactType(file.getUrl())) {
                modifiableModel.removeRoot(file.getUrl(), OrderRootType.CLASSES);
                continue;
            }
            exists.add(file);
        }
        for (VirtualFile file : modifiableModel.getFiles(OrderRootType.SOURCES)) {
            if (!compileDeps.contains(file) && OrderRootType.SOURCES == GrailsSettingSynchronizer.getArtifactType(file.getUrl())) {
                modifiableModel.removeRoot(file.getUrl(), OrderRootType.SOURCES);
                continue;
            }
            exists.add(file);
        }
        OrderRootType javadocType = JavadocOrderRootType.getInstance();
        for (VirtualFile file : modifiableModel.getFiles(javadocType)) {
            if (!compileDeps.contains(file) && javadocType == GrailsSettingSynchronizer.getArtifactType(file.getUrl())) {
                modifiableModel.removeRoot(file.getUrl(), javadocType);
                continue;
            }
            exists.add(file);
        }
        for (VirtualFile compileDep : compileDeps) {
            VirtualFile javadoc;
            VirtualFile sources;
            String version;
            String path;
            OrderRootType type = GrailsSettingSynchronizer.getArtifactType(compileDep.getUrl());
            if (!exists.contains(compileDep)) {
                modifiableModel.addRoot(compileDep, type);
            }
            if (type != OrderRootType.CLASSES) continue;
            String jarPath = compileDep.getPath();
            Matcher matcher = IVY_JAR_PATTERN.matcher(jarPath);
            if (matcher.matches()) {
                path = matcher.group(1);
                String name = matcher.group(2);
                version = matcher.group(3);
                sources = JarFileSystem.getInstance().findFileByPath(path + "/" + name + "/sources/" + name + "-" + version + "-sources.jar!/");
                if (sources != null && !exists.contains(sources)) {
                    modifiableModel.addRoot(sources, OrderRootType.SOURCES);
                    exists.add(sources);
                }
                if ((javadoc = JarFileSystem.getInstance().findFileByPath(path + '/' + name + "/javadocs/" + name + '-' + version + "-javadoc.jar!/")) == null || exists.contains(javadoc)) continue;
                modifiableModel.addRoot(javadoc, javadocType);
                exists.add(sources);
                continue;
            }
            matcher = MAVEN_JAR_PATTERN.matcher(jarPath);
            if (!matcher.matches()) continue;
            path = matcher.group(1);
            String artifactId = matcher.group(2);
            version = matcher.group(3);
            sources = JarFileSystem.getInstance().findFileByPath(path + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + "-sources.jar!/");
            if (sources != null && !exists.contains(sources)) {
                modifiableModel.addRoot(sources, OrderRootType.SOURCES);
                exists.add(sources);
            }
            if ((javadoc = JarFileSystem.getInstance().findFileByPath(path + '/' + artifactId + "/" + version + '/' + artifactId + '-' + version + "-javadoc.jar!/")) == null || exists.contains(javadoc)) continue;
            modifiableModel.addRoot(javadoc, javadocType);
            exists.add(sources);
        }
        if (modifiableModel.isChanged()) {
            modifiableModel.commit();
            model.commit();
        } else {
            Disposer.dispose((Disposable)modifiableModel);
            model.dispose();
        }
    }
}

