/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleScriptType;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfigurationType;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public class GradleCommandLineExecutor
extends GrailsCommandExecutor {
    private static final Map<String, String> ourCommandTasks = GrailsUtils.createMap("run-app", "grails-run-app", "test-app", "cleanGrails-test-app grails-test-app", "war", "grails-war");

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "isApplicable"));
        }
        return GrailsConfigUtils.isGradleGrailsIntegration(module);
    }

    @Override
    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "createJavaParameters"));
        }
        return GradleCommandLineExecutor.createParams(module, command);
    }

    @Override
    public JavaParameters createJavaParametersForRun(@NotNull Module module, boolean classpathFromDependencies, @Nullable Object additionalConfiguration, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "createJavaParametersForRun"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "createJavaParametersForRun"));
        }
        return GradleCommandLineExecutor.createParams(module, command);
    }

    private static JavaParameters createParams(@NotNull Module module, @NotNull MvcCommand command) throws CantRunException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "createParams"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "createParams"));
        }
        GroovyScriptRunConfiguration configuration = GradleCommandLineExecutor.getGroovyScriptRunConfiguration(module);
        if (command.getCommand() != null) {
            String task = ourCommandTasks.get(command.getCommand());
            configuration.setScriptParameters(StringUtil.notNullize((String)task, (String)("grails-" + command.getCommand())));
        }
        JavaParameters params = GroovyScriptRunConfiguration.createJavaParametersWithSdk((Module)module);
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)params, (CommonProgramRunConfigurationParameters)configuration);
        if (!command.getArgs().contains("--non-interactive")) {
            command.getArgs().add("--non-interactive");
        }
        if (!StringUtil.isEmpty((String)command.getEnv())) {
            params.getProgramParametersList().add("-PgrailsEnv=" + command.getEnv());
        }
        if (!command.getArgs().contains("-plain-output") && GrailsConfigUtils.isAtLeastGrails2_0(module)) {
            command.getArgs().add("-plain-output");
        }
        params.setDefaultCharset(module.getProject());
        GroovyScriptRunner groovyScriptRunner = GradleScriptType.INSTANCE.getRunner();
        assert (groovyScriptRunner != null);
        groovyScriptRunner.configureCommandLine(params, module, false, null, configuration);
        if (!command.getArgs().isEmpty()) {
            String args = StringUtil.join((Collection)command.getArgs(), (String)" ");
            params.getProgramParametersList().add("-PgrailsArgs=" + args);
            if ("test-app".equals(command.getCommand())) {
                params.getVMParametersList().add("-Dtest.single=" + args);
            }
        }
        return params;
    }

    private static GroovyScriptRunConfiguration getGroovyScriptRunConfiguration(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/gradle/GradleCommandLineExecutor", "getGroovyScriptRunConfiguration"));
        }
        GroovyScriptRunConfiguration configuration = new GroovyScriptRunConfiguration("Gradle Script", module.getProject(), GroovyScriptRunConfigurationType.getInstance().getConfigurationFactories()[0]);
        configuration.setModule(module);
        configuration.setScriptPath(module.getOptionValue("external.linked.project.path"));
        return configuration;
    }
}

