/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.task.TaskCallbackAdapter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.gradle.GrailsGradleInvoker;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GrailsGradleCommandExecutor
extends MvcCommandExecutor {
    protected boolean isApplicable(Module module) {
        return GrailsConfigUtils.isGradleGrailsIntegration(module);
    }

    @Nullable
    protected ConsoleProcessDescriptor doRun(@NotNull Module module, @NotNull MvcFramework framework, @NotNull MvcCommand mvcCommand, final @Nullable Runnable onDone, boolean showConsole, boolean closeOnDone, String ... input) {
        TaskCallbackAdapter taskCallback;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "doRun"));
        }
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "doRun"));
        }
        if (mvcCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mvcCommand", "org/jetbrains/plugins/grails/gradle/GrailsGradleCommandExecutor", "doRun"));
        }
        assert (framework instanceof GrailsFramework);
        TaskCallbackAdapter taskCallbackAdapter = taskCallback = onDone == null ? null : new TaskCallbackAdapter(){

            public void onSuccess() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        onDone.run();
                    }
                });
            }
        };
        if (mvcCommand.getArgs() == null) {
            mvcCommand.setArgs((List)ContainerUtil.newArrayList());
        }
        StringBuilder executionName = new StringBuilder().append(mvcCommand.getCommand());
        if (!mvcCommand.getArgs().isEmpty()) {
            executionName.append(": ").append(StringUtil.join((Collection)mvcCommand.getArgs(), (String)" "));
        }
        if (!mvcCommand.getArgs().contains("--non-interactive")) {
            mvcCommand.getArgs().add("--non-interactive");
        }
        if (!mvcCommand.getArgs().contains("-plain-output") && GrailsConfigUtils.isAtLeastGrails2_0(module)) {
            mvcCommand.getArgs().add("-plain-output");
        }
        new GrailsGradleInvoker(module).invoke(executionName.toString(), mvcCommand, (TaskCallback)taskCallback);
        return null;
    }
}

