/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttribute;
import org.jetbrains.plugins.grails.references.common.GspAttributeWrapper;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.XmlGspAttributeWrapper;
import org.jetbrains.plugins.grails.util.GrailsPatterns;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GrailsI18nPropertyReferenceProvider
extends PsiReferenceProvider {
    public static final ElementPattern<GspAttribute> ATTRIBUTE_PATTERN = new PsiElementPattern.Capture<GspAttribute>((InitialPatternCondition)new InitialPatternCondition<GspAttribute>(GspAttribute.class){

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            if (!(o instanceof GspAttribute)) {
                return false;
            }
            GspAttribute attr = (GspAttribute)o;
            return GrailsI18nPropertyReferenceProvider.getTypeOfReference(new XmlGspAttributeWrapper(attr)) != null;
        }
    }){};
    public static final XmlAttributeValuePattern ATTRIBUTE_VALUE_PATTERN = GrailsPatterns.gspAttributeValue(ATTRIBUTE_PATTERN);

    @Nullable
    public static Boolean getTypeOfReference(GspAttributeWrapper attr) {
        GspTagWrapper tag;
        String attributeName = attr.getName();
        if ("code".equals(attributeName)) {
            GspTagWrapper tag2 = attr.getTag();
            String tagName = tag2.getTagName();
            if ("g:message".equals(tagName)) {
                return tag2.hasAttribute("default");
            }
            if ("tooltip:tip".equals(tagName)) {
                return true;
            }
        } else if ("titleKey".equals(attributeName) && "g:sortableColumn".equals((tag = attr.getTag()).getTagName())) {
            return tag.hasAttribute("title");
        }
        return null;
    }

    @Nullable
    public static PropertyReference getReferenceByElement(@NotNull XmlAttributeValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/grails/i18n/GrailsI18nPropertyReferenceProvider", "getReferenceByElement"));
        }
        if (!GrailsPsiUtil.isSimpleAttribute(value)) {
            return null;
        }
        return new PropertyReference(value.getValue(), (PsiElement)value, "messages", true){

            protected List<PropertiesFile> retrievePropertyFilesByBundleName(String bundleName, PsiElement element) {
                VirtualFile i18nFile = GrailsUtils.findI18nDirectory(element);
                if (i18nFile == null) {
                    return super.retrievePropertyFilesByBundleName(bundleName, element);
                }
                PsiDirectory i18nPsiDir = this.getElement().getManager().findDirectory(i18nFile);
                if (i18nPsiDir == null) {
                    return super.retrievePropertyFilesByBundleName(bundleName, element);
                }
                ArrayList<PropertiesFile> res = new ArrayList<PropertiesFile>();
                for (PsiFile file : i18nPsiDir.getFiles()) {
                    if (!(file instanceof PropertiesFile)) continue;
                    res.add((PropertiesFile)file);
                }
                if (res.isEmpty()) {
                    return super.retrievePropertyFilesByBundleName(bundleName, element);
                }
                Collections.sort(res, new Comparator<PropertiesFile>(){

                    @Override
                    public int compare(PropertiesFile file1, PropertiesFile file2) {
                        return file1.getName().compareTo(file2.getName());
                    }
                });
                return res;
            }
        };
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/i18n/GrailsI18nPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/i18n/GrailsI18nPropertyReferenceProvider", "getReferencesByElement"));
        }
        PropertyReference reference = GrailsI18nPropertyReferenceProvider.getReferenceByElement((XmlAttributeValue)element);
        if (reference == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{reference};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/i18n/GrailsI18nPropertyReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

