/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang;

import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.settings.GrailsInjectedTraitService;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ast.AstTransformContributor;

public class Grails3TraitInjectorContributor
extends AstTransformContributor {
    public void collectImplementsTypes(GrTypeDefinition clazz, Collection<PsiClassType> collector) {
        if (!GrailsStructure.isVersionAtLeast("3.0", ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz))) {
            return;
        }
        Collection<String> injectedTraitsFQNs = GrailsInjectedTraitService.getInjectedTraits(clazz);
        if (injectedTraitsFQNs.isEmpty()) {
            return;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)clazz.getProject());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)clazz.getProject());
        final PsiClassType currentClassType = elementFactory.createType((PsiClass)clazz);
        for (String fqn : injectedTraitsFQNs) {
            PsiClass traitClass = psiFacade.findClass(fqn, clazz.getResolveScope());
            if (traitClass == null) continue;
            Object[] traitTypeParameters = traitClass.getTypeParameters();
            PsiType[] types = traitTypeParameters.length == 0 ? PsiType.EMPTY_ARRAY : (PsiType[])ContainerUtil.map2Array((Object[])traitTypeParameters, PsiType.class, (Function)new Function<PsiTypeParameter, PsiType>(){

                public PsiType fun(PsiTypeParameter typeParameter) {
                    return currentClassType;
                }
            });
            collector.add(elementFactory.createType(traitClass, types));
        }
    }
}

