/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSDocCommentBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.addins.GrailsIntegrationUtil;
import org.jetbrains.plugins.grails.addins.js.CssIntegrationUtil;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.lang.gsp.formatter.ForeignLanguageBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspHtmlBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.processors.GspIndentProcessor;

public class GspBlockGenerator {
    private GspBlockGenerator() {
    }

    public static void createGspBlockByTextRange(List<Block> result, ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, TextRange textRange) {
        String s;
        PsiElement parentPsi;
        ASTNode parent = child.getTreeParent();
        Indent indent = Indent.getNoneIndent();
        if (parent != null && (parentPsi = parent.getPsi()) instanceof XmlTag && policy.indentChildrenOf((XmlTag)parentPsi)) {
            indent = Indent.getNormalIndent();
        }
        if (!child.getTextRange().contains(textRange)) {
            return;
        }
        String text = child.getPsi().getContainingFile().getText();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        String string = s = end < text.length() - 1 ? text.substring(start, end) : text.substring(start);
        if (s.trim().length() == 0) {
            return;
        }
        while (!text.substring(start, start + 1).equals(text.substring(start, start + 1).trim())) {
            ++start;
        }
        while (!text.substring(end - 1, end).equals(text.substring(end - 1, end).trim())) {
            --end;
        }
        assert (start < end);
        result.add(new GspBlock(child, wrap, alignment, policy, indent, new TextRange(start, end)));
    }

    public static void createGspBlockByChildNode(List<Block> result, ASTNode parentNode, ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy) {
        if (!GspBlockGenerator.canBeCorrectBlock(child)) {
            return;
        }
        result.add(new GspBlock(child, wrap, alignment, policy, GspIndentProcessor.getGspChildIndent(parentNode, child, policy), child.getTextRange()));
    }

    public static void createHtmlBlockByChildNode(List<Block> result, ASTNode parentNode, ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, XmlTag[] nestedGspTags) {
        if (!GspBlockGenerator.canBeCorrectBlock(child)) {
            return;
        }
        PsiElement childPsi = child.getPsi();
        if (GrailsIntegrationUtil.isJsSupportEnabled() && (JavaScriptIntegrationUtil.isJavaScriptInjection(childPsi) || JavaScriptIntegrationUtil.isJSEmbeddedContent(childPsi))) {
            GspBlockGenerator.createForeignLanguageBlock(JavaScriptSupportLoader.JAVASCRIPT.getLanguage(), child, result, policy, policy.getSettings());
        } else if (GrailsIntegrationUtil.isCssSupportEnabled() && childPsi instanceof CssStylesheet) {
            GspBlockGenerator.createForeignLanguageBlock(childPsi.getLanguage(), child, result, policy, policy.getSettings());
        } else {
            result.add(new GspHtmlBlock(child, wrap, alignment, policy, GspIndentProcessor.getGspChildIndent(parentNode, child, policy), nestedGspTags));
        }
    }

    public static void createForeignLanguageBlock(Language childLanguage, ASTNode child, List<Block> result, XmlFormattingPolicy policy, CodeStyleSettings settings) {
        PsiElement childPsi = child.getPsi();
        if (JavaScriptIntegrationUtil.isJavaScriptInjection(childPsi)) {
            GspBlockGenerator.generateBlockForJSInjection(childPsi, result, settings);
        } else {
            FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext(childLanguage, childPsi);
            if (builder != null) {
                FormattingModel childModel = builder.createModel(childPsi, settings);
                Indent childIndent = GrailsIntegrationUtil.isCssSupportEnabled() && CssIntegrationUtil.isCssLanguage(childLanguage) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                result.add((Block)new ForeignLanguageBlock(child, policy, childModel.getRootBlock(), childIndent));
            }
        }
    }

    private static void generateBlockForJSInjection(PsiElement outer, List<Block> result, CodeStyleSettings settings) {
        PsiFile file = outer.getContainingFile();
        int offset = outer.getTextRange().getStartOffset();
        PsiElement element = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)offset);
        FormattingModelBuilder builder = GspBlockGenerator.getJSFormattingModelBuilder(offset, file, outer);
        if (builder != null) {
            FormattingModel childModel = builder.createModel(element, settings);
            Block rootJsBlock = childModel.getRootBlock();
            result.add(rootJsBlock);
        }
    }

    private static FormattingModelBuilder getJSFormattingModelBuilder(final int offset, final PsiFile file, final PsiElement outer) {
        return new FormattingModelBuilder(){

            @NotNull
            public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
                MyJSRootBlock jsBlock = new MyJSRootBlock(outer, settings, offset, file);
                FormattingModel formattingModel = JavascriptFormattingModelBuilder.createJSFormattingModel((PsiFile)file, (CodeStyleSettings)settings, (Block)jsBlock);
                if (formattingModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$1", "createModel"));
                }
                return formattingModel;
            }

            @Nullable
            public TextRange getRangeAffectingIndent(PsiFile file2, int offset2, ASTNode elementAtOffset) {
                return null;
            }
        };
    }

    public static boolean canBeCorrectBlock(ASTNode node) {
        return node != null && node.getText().trim().length() > 0;
    }

    private static class MyJSRootBlock
    extends JSBlock {
        private List<Block> mySubBlocks;
        private final CodeStyleSettings mySettings;
        private final int myOffset;
        private final PsiFile myFile;

        private MyJSRootBlock(PsiElement outer, CodeStyleSettings settings, int offset, PsiFile file) {
            super(outer.getNode(), null, Indent.getNormalIndent(), null, settings);
            this.mySettings = settings;
            this.myOffset = offset;
            this.myFile = file;
            this.mySubBlocks = null;
        }

        @NotNull
        public List<Block> getSubBlocks() {
            if (this.mySubBlocks == null) {
                MyJSSubBlockVisitor visitor = new MyJSSubBlockVisitor(this.mySettings, this.myOffset);
                PsiFile jsFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)this.myFile, (int)this.myOffset);
                if (jsFile != null && jsFile.getNode() != null) {
                    visitor.visit((ASTNode)jsFile.getNode());
                }
                this.mySubBlocks = visitor.getBlocks();
            }
            List<Block> list = this.mySubBlocks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSRootBlock", "getSubBlocks"));
            }
            return list;
        }
    }

    private static class MyJSBlock
    extends JSBlock {
        private final int myOffset;
        private final CodeStyleSettings mySettings;

        public MyJSBlock(ASTNode child, Alignment childAlignment, Indent childIndent, Wrap wrap, CodeStyleSettings settings, int offset) {
            super(child, childAlignment, childIndent, wrap, settings);
            this.myOffset = offset;
            this.mySettings = settings;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = super.getTextRange().shiftRight(this.myOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSBlock", "getTextRange"));
            }
            return textRange;
        }

        protected SubBlockVisitor createSubBlockVisitor() {
            return new MyJSSubBlockVisitor(this.mySettings, this.myOffset);
        }
    }

    private static class MyJSSubBlockVisitor
    extends SubBlockVisitor {
        private final CodeStyleSettings mySettings;
        private final int myOffset;

        public MyJSSubBlockVisitor(CodeStyleSettings settings, int offset) {
            super(settings);
            this.mySettings = settings;
            this.myOffset = offset;
        }

        protected void addBlock(final Block block) {
            if (block instanceof JSDocCommentBlock) {
                super.addBlock(new Block(){

                    @NotNull
                    public TextRange getTextRange() {
                        TextRange textRange = block.getTextRange().shiftRight(MyJSSubBlockVisitor.this.myOffset);
                        if (textRange == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSSubBlockVisitor$1", "getTextRange"));
                        }
                        return textRange;
                    }

                    @NotNull
                    public List<Block> getSubBlocks() {
                        List list = block.getSubBlocks();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSSubBlockVisitor$1", "getSubBlocks"));
                        }
                        return list;
                    }

                    public Wrap getWrap() {
                        return block.getWrap();
                    }

                    public Indent getIndent() {
                        return block.getIndent();
                    }

                    public Alignment getAlignment() {
                        return block.getAlignment();
                    }

                    public Spacing getSpacing(Block child1, @NotNull Block child2) {
                        if (child2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSSubBlockVisitor$1", "getSpacing"));
                        }
                        return block.getSpacing(child1, child2);
                    }

                    @NotNull
                    public ChildAttributes getChildAttributes(int newChildIndex) {
                        ChildAttributes childAttributes = block.getChildAttributes(newChildIndex);
                        if (childAttributes == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspBlockGenerator$MyJSSubBlockVisitor$1", "getChildAttributes"));
                        }
                        return childAttributes;
                    }

                    public boolean isIncomplete() {
                        return block.isIncomplete();
                    }

                    public boolean isLeaf() {
                        return block.isLeaf();
                    }
                });
            } else {
                super.addBlock(block);
            }
        }

        public void visitElement(ASTNode node) {
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
                Wrap wrap = this.getWrap(node, child);
                Indent childIndent = this.getIndent(node, child, null);
                MyJSBlock jsBlock = new MyJSBlock(child, null, childIndent, wrap, this.mySettings, this.myOffset);
                this.getBlocks().add(jsBlock);
            }
        }
    }
}

