/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.highlighter.GspDirectiveHighlightingLexer;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;

public class GspDirectiveHighlighter
extends SyntaxHighlighterBase
implements GspTokenTypes {
    static final TokenSet tGSP_DIRECT_SEPARATORS = TokenSet.create((IElementType[])new IElementType[]{GTAG_END_TAG_START, GTAG_START_TAG_START, GTAG_START_TAG_END, GTAG_TAG_END, JDIRECT_BEGIN, JDIRECT_END, GDIRECT_BEGIN, GDIRECT_END});
    static final TokenSet tGSP_DIRECT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{GSP_WHITE_SPACE, GSP_TAG_NAME, GSP_ATTR_NAME, GSP_EQ, GSP_BAD_CHARACTER, GSP_ATTR_VALUE_START_DELIMITER, GSP_ATTR_VALUE_END_DELIMITER, GSP_ATTRIBUTE_VALUE_TOKEN});

    @NotNull
    public Lexer getHighlightingLexer() {
        GspDirectiveHighlightingLexer gspDirectiveHighlightingLexer = new GspDirectiveHighlightingLexer();
        if (gspDirectiveHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getHighlightingLexer"));
        }
        return gspDirectiveHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tGSP_DIRECT_SEPARATORS.contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = GspDirectiveHighlighter.pack((TextAttributesKey)JspHighlighterColors.JSP_DIRECTIVE_STAT_END_MARKER);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (tokenType == GSP_ATTR_NAME) {
            TextAttributesKey[] textAttributesKeyArray = GspDirectiveHighlighter.pack((TextAttributesKey)JspHighlighterColors.JSP_ATTRIBUTE_NAME);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (tokenType == GSP_TAG_NAME) {
            TextAttributesKey[] textAttributesKeyArray = GspDirectiveHighlighter.pack((TextAttributesKey)JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_NAME);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (tokenType == GSP_ATTRIBUTE_VALUE_TOKEN) {
            TextAttributesKey[] textAttributesKeyArray = GspDirectiveHighlighter.pack((TextAttributesKey)JspHighlighterColors.JSP_ATTRIBUTE_VALUE);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (tGSP_DIRECT_TOKENS.contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = GspDirectiveHighlighter.pack((TextAttributesKey)JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_BACKGROUND);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = GspDirectiveHighlighter.pack(null);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspDirectiveHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }
}

