/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag;

import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.GspTagLibUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GspTagDescriptorService {
    private static final Map<String, TagDescriptor> tagMap = new LinkedHashMap<String, TagDescriptor>();
    private Map<String, Pair<XmlAttributeDescriptor[], Map<String, XmlAttributeDescriptor>>> myTagDescriptors;

    public GspTagDescriptorService(Project project) {
        PsiFile gspFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.gsp", (FileType)GspFileType.GSP_FILE_TYPE, (CharSequence)"");
        Map<String, XmlAttributeDescriptor[]> htmlTagAttributes = GspTagDescriptorService.getHtmlTagAttributes(project);
        HashMap<String, Pair<XmlAttributeDescriptor[], Map<String, XmlAttributeDescriptor>>> tagDescriptors = new HashMap<String, Pair<XmlAttributeDescriptor[], Map<String, XmlAttributeDescriptor>>>();
        TldDescriptor descriptor = GspTagDescriptorService.getTldDescriptor(project);
        if (descriptor != null) {
            XmlDocument document = (XmlDocument)gspFile.getFirstChild();
            assert (document != null);
            XmlTag gspRootTag = (XmlTag)document.getFirstChild().getNextSibling();
            for (XmlElementDescriptor elementDescriptor : descriptor.getRootElementsDescriptors(document)) {
                int n;
                XmlAttributeDescriptor[] htmlAttr;
                String tagName = elementDescriptor.getName();
                LinkedHashMap<String, XmlAttributeDescriptor> attrMap = new LinkedHashMap<String, XmlAttributeDescriptor>();
                TagDescriptor tagDescriptor = tagMap.get(tagName);
                if (tagDescriptor != null) {
                    for (XmlAttributeDescriptor attrDescr : htmlAttr = htmlTagAttributes.get(tagDescriptor.htmlTag)) {
                        attrMap.put(attrDescr.getName(), attrDescr);
                    }
                    String[] stringArray = tagDescriptor.excludedAttributes;
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String excluded = stringArray[i];
                        attrMap.remove(excluded);
                    }
                }
                htmlAttr = elementDescriptor.getAttributesDescriptors(gspRootTag);
                int n2 = htmlAttr.length;
                for (n = 0; n < n2; ++n) {
                    XmlAttributeDescriptor attrDescr = htmlAttr[n];
                    attrMap.put(attrDescr.getName(), attrDescr);
                }
                XmlAttributeDescriptor[] allAttributes = attrMap.values().toArray(new XmlAttributeDescriptor[attrMap.values().size()]);
                tagDescriptors.put(tagName, (Pair<XmlAttributeDescriptor[], Map<String, XmlAttributeDescriptor>>)Pair.create((Object)allAttributes, attrMap));
            }
        }
        this.myTagDescriptors = tagDescriptors;
    }

    private static Map<String, XmlAttributeDescriptor[]> getHtmlTagAttributes(Project project) {
        XmlTag[] htmlTags;
        HashMap<String, XmlAttributeDescriptor[]> res = new HashMap<String, XmlAttributeDescriptor[]>();
        for (Map.Entry<String, TagDescriptor> entry : tagMap.entrySet()) {
            TagDescriptor tagDescriptor = entry.getValue();
            if (tagDescriptor == null) continue;
            res.put(tagDescriptor.htmlTag, null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        for (String htmlTag : res.keySet()) {
            sb.append('<').append(htmlTag).append("/>");
        }
        sb.append("</body></html>");
        PsiFile htmlFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.html", StdLanguages.HTML, (CharSequence)sb);
        for (XmlTag tag : htmlTags = ((XmlTag)htmlFile.getFirstChild().getFirstChild().getNextSibling()).getSubTags()[0].getSubTags()) {
            res.put(tag.getName(), tag.getDescriptor().getAttributesDescriptors(tag));
        }
        return res;
    }

    public static Set<String> getAllTags() {
        return tagMap.keySet();
    }

    public static GspTagDescriptorService getInstance(Project project) {
        return (GspTagDescriptorService)ServiceManager.getService((Project)project, GspTagDescriptorService.class);
    }

    public XmlAttributeDescriptor[] getAttributesDescriptors(String tagName) {
        Pair<XmlAttributeDescriptor[], Map<String, XmlAttributeDescriptor>> pair = this.myTagDescriptors.get(tagName);
        return pair == null ? XmlAttributeDescriptor.EMPTY : (XmlAttributeDescriptor[])pair.first;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributesDescriptor(String tagName, String attributeName) {
        Pair<XmlAttributeDescriptor[], Map<String, XmlAttributeDescriptor>> pair = this.myTagDescriptors.get(tagName);
        if (pair == null) {
            return null;
        }
        return (XmlAttributeDescriptor)((Map)pair.second).get(attributeName);
    }

    @Nullable
    public static TldDescriptor getTldDescriptor(Project project) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(GspTagDescriptorService.getTldFile());
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        return GrailsUtils.getTldDescriptor((XmlFile)psiFile);
    }

    @NotNull
    public static VirtualFile getTldFile() {
        String path = PathUtil.getJarPathForClass(GspTagLibUtil.class);
        VirtualFile tldFile = path.endsWith(".jar") ? JarFileSystem.getInstance().findFileByPath(path + "!/org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/tld/grails.tld") : LocalFileSystem.getInstance().findFileByPath(path + "/org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/tld/grails.tld");
        assert (tldFile != null);
        VirtualFile virtualFile = tldFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/GspTagDescriptorService", "getTldFile"));
        }
        return virtualFile;
    }

    static {
        tagMap.put("actionSubmit", new TagDescriptor("input", new String[]{"type", "name", "value"}));
        tagMap.put("actionSubmitImage", new TagDescriptor("input", new String[]{"type", "name", "value"}));
        tagMap.put("applyLayout", null);
        tagMap.put("checkBox", new TagDescriptor("input", new String[]{"type", "name", "value", "checked"}));
        tagMap.put("collect", null);
        tagMap.put("cookie", null);
        tagMap.put("country", null);
        tagMap.put("countrySelect", new TagDescriptor("select", new String[]{"name"}));
        tagMap.put("createLink", null);
        tagMap.put("createLinkTo", null);
        tagMap.put("currencySelect", new TagDescriptor("select", new String[]{"name"}));
        tagMap.put("datePicker", null);
        tagMap.put("def", null);
        tagMap.put("each", null);
        tagMap.put("eachError", null);
        tagMap.put("else", null);
        tagMap.put("elseif", null);
        tagMap.put("encodeAs", null);
        tagMap.put("escapeJavascript", null);
        tagMap.put("external", null);
        tagMap.put("field", new TagDescriptor("input", new String[]{"type"}));
        tagMap.put("fieldError", null);
        tagMap.put("fieldValue", null);
        tagMap.put("findAll", null);
        tagMap.put("form", new TagDescriptor("form", new String[]{"action", "method"}));
        tagMap.put("formatBoolean", null);
        tagMap.put("formatDate", null);
        tagMap.put("formatNumber", null);
        tagMap.put("formRemote", new TagDescriptor("form", new String[]{"action", "method", "onsubmit"}));
        tagMap.put("grep", null);
        tagMap.put("hasErrors", null);
        tagMap.put("header", null);
        tagMap.put("hiddenField", new TagDescriptor("input", new String[]{"type", "name"}));
        tagMap.put("if", null);
        tagMap.put("ifPageProperty", null);
        tagMap.put("img", new TagDescriptor("img", new String[]{"dir", "uri", "file", "plugin"}));
        tagMap.put("include", null);
        tagMap.put("javascript", null);
        tagMap.put("join", null);
        tagMap.put("layoutBody", null);
        tagMap.put("layoutHead", null);
        tagMap.put("layoutTitle", null);
        tagMap.put("link", new TagDescriptor("a", new String[]{"href"}));
        tagMap.put("localeSelect", new TagDescriptor("select", new String[]{"name"}));
        tagMap.put("message", null);
        tagMap.put("meta", null);
        tagMap.put("pageProperty", null);
        tagMap.put("paginate", null);
        tagMap.put("passwordField", new TagDescriptor("input", new String[]{"type", "name"}));
        tagMap.put("radio", new TagDescriptor("input", new String[]{"type", "name", "value", "checked"}));
        tagMap.put("radioGroup", new TagDescriptor("input", new String[]{"type", "name", "value", "checked"}));
        tagMap.put("remoteField", new TagDescriptor("input", new String[]{"type", "name", "value", "onkeyup"}));
        tagMap.put("remoteFunction", null);
        tagMap.put("remoteLink", new TagDescriptor("a", new String[]{"onclick"}));
        tagMap.put("render", null);
        tagMap.put("renderException", null);
        tagMap.put("resource", null);
        tagMap.put("renderErrors", null);
        tagMap.put("renderInput", null);
        tagMap.put("select", new TagDescriptor("select", new String[]{"name"}));
        tagMap.put("set", null);
        tagMap.put("setProvider", null);
        tagMap.put("sortableColumn", null);
        tagMap.put("submitButton", new TagDescriptor("input", new String[]{"type", "name", "value"}));
        tagMap.put("submitToRemote", new TagDescriptor("input", new String[]{"type", "name", "value"}));
        tagMap.put("textArea", new TagDescriptor("textarea", new String[0]));
        tagMap.put("textField", new TagDescriptor("input", new String[]{"type", "name", "value"}));
        tagMap.put("timeZoneSelect", new TagDescriptor("select", new String[]{"name"}));
        tagMap.put("uploadForm", new TagDescriptor("form", new String[]{"action", "method", "enctype"}));
        tagMap.put("unless", null);
        tagMap.put("validate", null);
        tagMap.put("withTag", null);
        tagMap.put("while", null);
    }

    private static class TagDescriptor {
        public final String htmlTag;
        public final String[] excludedAttributes;

        private TagDescriptor(String htmlTag, String ... excludedAttributes) {
            this.htmlTag = htmlTag;
            this.excludedAttributes = excludedAttributes;
        }
    }
}

