/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.resolve.taglib;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import icons.GroovyMvcIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.GspTagLibUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrImplicitVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenamableLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class TagLibNamespaceDescriptor {
    public static final String GSP_TAG_METHOD_MARKER = "Grails:GSP_TAG";
    private final String myNamespacePrefix;
    private final PsiManager myManager;
    private final List<PsiClass> myClasses = new ArrayList<PsiClass>();
    private Map<String, PsiMethod> myVariableCache;
    private volatile Map<String, PsiMethod> myFinalCalculatedVariables;
    private volatile PsiVariable myDummyClassVariable;
    private final Module myModule;
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"grailsTaglibDescriptor");

    TagLibNamespaceDescriptor(String namespacePrefix, Module module) {
        this.myNamespacePrefix = namespacePrefix;
        this.myModule = module;
        this.myManager = PsiManager.getInstance((Project)module.getProject());
    }

    void addClass(PsiClass aClass) {
        this.myClasses.add(aClass);
    }

    @NotNull
    public String getNamespacePrefix() {
        String string = this.myNamespacePrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor", "getNamespacePrefix"));
        }
        return string;
    }

    public List<PsiClass> getClasses() {
        return this.myClasses;
    }

    public Collection<PsiMethod> getAllTags() {
        if (this.myFinalCalculatedVariables != null) {
            return this.myFinalCalculatedVariables.values();
        }
        HashMap<String, PsiMethod> variableMap = new HashMap<String, PsiMethod>();
        Set<String> exclude = GspTagLibUtil.getExcludedTags(this.myNamespacePrefix);
        for (Map.Entry<String, PsiMethod> entry : GrailsUtils.collectClosureProperties(this.myClasses).entrySet()) {
            String name = entry.getKey();
            if (exclude.contains(name)) continue;
            PsiMember element = GrailsUtils.toField(entry.getValue());
            variableMap.put(name, (PsiMethod)new GspTagMethod(this.myManager, name, element));
        }
        this.myFinalCalculatedVariables = variableMap;
        return variableMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiMethod getTag(final @NotNull String name) {
        GspTagMethod res;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor", "getTag"));
        }
        if (this.myFinalCalculatedVariables != null) {
            return this.myFinalCalculatedVariables.get(name);
        }
        if (GspTagLibUtil.getExcludedTags(this.myNamespacePrefix).contains(name)) {
            return null;
        }
        TagLibNamespaceDescriptor tagLibNamespaceDescriptor = this;
        synchronized (tagLibNamespaceDescriptor) {
            if (this.myVariableCache != null && this.myVariableCache.containsKey(name)) {
                return this.myVariableCache.get(name);
            }
        }
        RecursionGuard.StackStamp stamp = ourGuard.markStack();
        PsiMethod[] method = (PsiMethod[])ourGuard.doPreventingRecursion((Object)name, true, (Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                return new PsiMethod[]{GrailsUtils.getClosureProperty(TagLibNamespaceDescriptor.this.myClasses, name)};
            }
        });
        if (method == null) {
            return null;
        }
        GspTagMethod gspTagMethod = res = method[0] == null ? null : new GspTagMethod(this.myManager, name, GrailsUtils.toField(method[0]));
        if (stamp.mayCacheNow()) {
            TagLibNamespaceDescriptor tagLibNamespaceDescriptor2 = this;
            synchronized (tagLibNamespaceDescriptor2) {
                if (this.myVariableCache == null) {
                    this.myVariableCache = new HashMap<String, PsiMethod>();
                }
                this.myVariableCache.put(name, (PsiMethod)res);
            }
        }
        return res;
    }

    public boolean processTags(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable String name) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor", "processTags"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor", "processTags"));
        }
        if (name == null) {
            for (PsiMethod variable : this.getAllTags()) {
                if (processor.execute((PsiElement)variable, state)) continue;
                return false;
            }
        } else {
            PsiMethod variable = this.getTag(name);
            if (variable != null && !processor.execute((PsiElement)variable, state)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PsiVariable getDummyClassVariable() {
        Object dummyClassVariable = this.myDummyClassVariable;
        if (dummyClassVariable == null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
            PsiClass objectClass = facade.findClass("java.lang.Object", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule));
            if (objectClass == null) {
                return null;
            }
            DummyClass dummyClass = new DummyClass(objectClass);
            PsiElementFactory factory = facade.getElementFactory();
            PsiClassType type = factory.createType((PsiClass)dummyClass);
            this.myDummyClassVariable = dummyClassVariable = new GrImplicitVariableImpl(this.myManager, (PsiIdentifier)new LightIdentifier(this.myManager, this.myNamespacePrefix), (PsiType)type, false, null){

                public Icon getIcon(int flags) {
                    return GroovyMvcIcons.Grails;
                }
            };
        }
        return dummyClassVariable;
    }

    public class GspTagMethod
    extends GrRenamableLightMethodBuilder {
        public GspTagMethod(@NotNull PsiManager manager, @NotNull String name, PsiMember navigationElement) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$GspTagMethod", "<init>"));
            }
            if (navigationElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$GspTagMethod", "<init>"));
            }
            super(manager, name);
            this.setNavigationElement((PsiElement)navigationElement);
            this.addParameter("attr", "java.util.Map", true);
            this.addParameter("body", "java.lang.Object", true);
            this.setContainingClass(navigationElement.getContainingClass());
            this.setMethodKind(TagLibNamespaceDescriptor.GSP_TAG_METHOD_MARKER);
        }

        public Icon getIcon(int flags) {
            return GroovyMvcIcons.Grails;
        }

        public PsiType getReturnType() {
            return JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createTypeByFQClassName("org.codehaus.groovy.grails.web.util.StreamCharBuffer", this.getNavigationElement().getResolveScope());
        }

        public String getTagName() {
            return TagLibNamespaceDescriptor.this.myNamespacePrefix + ':' + this.getName();
        }

        public String getNamespacePrefix() {
            return TagLibNamespaceDescriptor.this.myNamespacePrefix;
        }

        protected void onRename(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$GspTagMethod", "onRename"));
            }
            PsiElement element = this.getNavigationElement();
            ((PsiNamedElement)element).setName(newName);
        }

        @NotNull
        public SearchScope getUseScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)TagLibNamespaceDescriptor.this.myModule), (FileType[])new FileType[]{GroovyFileType.GROOVY_FILE_TYPE, GspFileType.GSP_FILE_TYPE});
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$GspTagMethod", "getUseScope"));
            }
            return globalSearchScope;
        }
    }

    public class DummyClass
    extends LightClass {
        private final String myClassName;

        public DummyClass(PsiClass delegate) {
            super(delegate, (Language)GroovyLanguage.INSTANCE);
            this.myClassName = "_namespace_" + TagLibNamespaceDescriptor.this.myNamespacePrefix;
        }

        public String getName() {
            return this.myClassName;
        }

        public String getQualifiedName() {
            return this.myClassName;
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$DummyClass", "processDeclarations"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$DummyClass", "processDeclarations"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/TagLibNamespaceDescriptor$DummyClass", "processDeclarations"));
            }
            ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
            return classHint != null && !classHint.shouldProcess(ClassHint.ResolveKind.METHOD) || TagLibNamespaceDescriptor.this.processTags(processor, state, ResolveUtil.getNameHint((PsiScopeProcessor)processor));
        }
    }
}

