/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.plugins.grails.maven.MavenCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;

public class GrailsMavenDebuggerRunner
extends GenericDebuggerRunner {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner", "canRun"));
        }
        if (profile instanceof GrailsRunConfiguration && DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) {
            Module module = ((GrailsRunConfiguration)profile).getModule();
            if (module == null) {
                return false;
            }
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
            MavenProject mavenProject = mavenProjectsManager.findProject(module);
            return mavenProject != null && mavenProject.findPlugin("org.grails", "grails-maven-plugin") != null && !ExternalSystemApiUtil.isExternalSystemAwareModule((String)"GRADLE", (Module)module);
        }
        return false;
    }

    @NotNull
    public String getRunnerId() {
        if ("GrailsMavenDebuggerRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner", "getRunnerId"));
        }
        return "GrailsMavenDebuggerRunner";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        ServerSocket serverSocket;
        File tmpFile;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner", "createContentDescriptor"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/maven/GrailsMavenDebuggerRunner", "createContentDescriptor"));
        }
        if (!(state instanceof GrailsRunConfiguration.GrailsCommandLineState) || !(((GrailsRunConfiguration.GrailsCommandLineState)state).getExecutor() instanceof MavenCommandExecutor)) {
            return super.createContentDescriptor(state, environment);
        }
        try {
            tmpFile = File.createTempFile("grailsStartFlag", "");
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to create temp file", (Throwable)e);
        }
        tmpFile.deleteOnExit();
        JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
        GrailsCommandExecutor.addAgentJar(parameters);
        GrailsUtils.addSystemPropertyIfNotExists(parameters.getVMParametersList(), "-DforkDebug=true");
        GrailsMavenDebuggerRunner.runCustomPatchers((JavaParameters)parameters, (Executor)environment.getExecutor(), (RunProfile)environment.getRunProfile());
        RemoteConnection connection = DebuggerManagerImpl.createDebugParameters((JavaParameters)parameters, (boolean)false, (int)0, (String)"", (boolean)false);
        parameters.getVMParametersList().addProperty("idea.grails.kind.file", tmpFile.getAbsolutePath());
        RemoteConnection c2 = new RemoteConnection(true, "127.0.0.1", DebuggerUtils.getInstance().findAvailableDebugAddress(true), false);
        try {
            serverSocket = new ServerSocket(Integer.parseInt(c2.getAddress()));
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to open server socket", (Throwable)e);
        }
        try {
            RunContentDescriptor descriptor = this.attachVirtualMachine(state, environment, c2, true);
            try {
                SocketThread socketThread = new SocketThread(serverSocket.accept(), tmpFile, descriptor.getProcessHandler(), Integer.parseInt(connection.getAddress()));
                Thread t = new Thread((Runnable)socketThread, "grails socket thread");
                t.setDaemon(true);
                t.start();
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to open server socket", (Throwable)e);
            }
            RunContentDescriptor runContentDescriptor = descriptor;
            return runContentDescriptor;
        }
        finally {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class SocketThread
    implements Runnable {
        private final Socket mySocket;
        private final File myFile;
        private final ProcessHandler myProcessHandler;
        private final int myMavenProcessPort;

        private SocketThread(Socket socket, File file, ProcessHandler processHandler, int mavenProcessPort) {
            this.mySocket = socket;
            this.myFile = file;
            this.myProcessHandler = processHandler;
            this.myMavenProcessPort = mavenProcessPort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int debugPort;
                while (true) {
                    if (this.myProcessHandler.isProcessTerminated()) {
                        return;
                    }
                    long length = this.myFile.length();
                    if (length != 0L) {
                        this.myFile.delete();
                        if (length == 1L) {
                            debugPort = this.myMavenProcessPort;
                            break;
                        }
                        debugPort = 5005;
                        Thread.sleep(1000L);
                        break;
                    }
                    Thread.sleep(300L);
                }
                final Socket debuggedProcessSocket = new Socket("127.0.0.1", debugPort);
                try {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SocketThread.copyStream(SocketThread.this.mySocket.getInputStream(), debuggedProcessSocket.getOutputStream());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }, "copy stream");
                    t.setDaemon(true);
                    t.start();
                    SocketThread.copyStream(debuggedProcessSocket.getInputStream(), this.mySocket.getOutputStream());
                }
                finally {
                    debuggedProcessSocket.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                try {
                    this.mySocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        private static void copyStream(InputStream in, OutputStream out) throws IOException {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
    }
}

