/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.facet.FacetManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;

public class GrailsMavenImporter
extends MavenImporter {
    private static final Logger LOG = Logger.getInstance(GrailsMavenImporter.class);
    private static final Set<String> IMPORTED_ARTIFACT_GROUPS = ContainerUtil.newTroveSet((Object[])new String[]{"javax.servlet", "org.grails"});

    public GrailsMavenImporter() {
        super("org.grails", "grails-maven-plugin");
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        for (MavenArtifact artifact : mavenProject.getDependencies()) {
            if (!"runtime".equals(artifact.getScope())) continue;
            artifact.setScope("compile");
        }
        MavenPlugin plugin = mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        if (plugin == null) {
            return;
        }
        THashSet projectDeps = new THashSet();
        for (MavenArtifact dep : mavenProject.getDependencies()) {
            projectDeps.add(dep.getMavenId());
        }
        Collection pluginDeps = embedder.resolvePlugin(plugin, mavenProject.getRemoteRepositories(), nativeMavenProject, true);
        for (MavenArtifact each : pluginDeps) {
            MavenArtifact projectDependency;
            List list;
            if (this.myPluginGroupID.equals(each.getGroupId()) && this.myPluginArtifactID.equals(each.getArtifactId())) continue;
            if (IMPORTED_ARTIFACT_GROUPS.contains(each.getGroupId()) && projectDeps.add(each.getMavenId())) {
                each.setScope("compile");
                mavenProject.addDependency(each);
            }
            if ((list = mavenProject.findDependencies(each.getGroupId(), each.getArtifactId())).size() != 1 || (projectDependency = (MavenArtifact)list.get(0)).getVersion().equals(each.getVersion()) || !projectDependency.getMavenId().equals("org.slf4j", "slf4j-api")) continue;
            each.setScope("compile");
            mavenProject.addDependency(each);
        }
    }

    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    public void process(IdeModifiableModelsProvider modifiableModelsProvider, Module module, MavenRootModelAdapter rootModel, MavenProjectsTree mavenModel, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        for (GrailsFacetProvider provider : (GrailsFacetProvider[])GrailsFacetProvider.EP_NAME.getExtensions()) {
            provider.addFacets(actions, facetManager, module, Collections.singletonList(mavenProject.getDirectoryFile()));
        }
        for (Runnable action : actions) {
            action.run();
        }
    }

    public void collectSourceRoots(MavenProject mavenProject, PairConsumer<String, JpsModuleSourceRootType<?>> result) {
        for (Map.Entry entry : GrailsFramework.GRAILS_SOURCE_FOLDERS.entrySet()) {
            JpsModuleSourceRootType type = (JpsModuleSourceRootType)entry.getKey();
            for (String path : (Collection)entry.getValue()) {
                result.consume((Object)path, (Object)type);
            }
        }
    }
}

