/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class MavenCommandExecutor
extends GrailsCommandExecutor {
    private static final Map<String, String> ourCommandGoals = GrailsUtils.createMap("run-app", "grails:run-app", "test-app", "grails:test-app", "war", "grails:war");

    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "isApplicable"));
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
        MavenProject mavenProject = mavenProjectsManager.findProject(module);
        if (mavenProject != null) {
            return mavenProject.findPlugin("org.grails", "grails-maven-plugin") != null;
        }
        return false;
    }

    @Override
    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        return MavenCommandExecutor.createJavaParameters(module, null, command);
    }

    private static JavaParameters createJavaParameters(@NotNull Module module, @Nullable MavenGeneralSettings generalSettings, @NotNull MvcCommand command) throws ExecutionException {
        ParametersList vmOptionList;
        String workDir;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance((Project)module.getProject());
        MavenProject mavenProject = projectsManager.findProject(module);
        if (mavenProject != null) {
            workDir = mavenProject.getDirectory();
        } else {
            VirtualFile appRoot = GrailsFramework.getInstance().findAppRoot(module);
            assert (appRoot != null) : "MavenCommandExecutor cannot run non-grails modules";
            workDir = appRoot.getPath();
        }
        MavenRunnerSettings settings = MavenRunner.getInstance((Project)module.getProject()).getSettings().clone();
        settings.setVmOptions(command.getVmOptions());
        String parameterStr = null;
        if (command.getArgs().size() > 0) {
            parameterStr = ParametersList.join((List)command.getArgs());
        }
        String goal = null;
        String mappedGoal = ourCommandGoals.get(command.getCommand());
        if ("test-app".equals(command.getCommand())) {
            String grailsVersion = null;
            GrailsStructure grailsStructure = GrailsStructure.getInstance(module);
            if (grailsStructure != null) {
                grailsVersion = grailsStructure.getGrailsVersion();
            }
            if (grailsVersion != null && grailsVersion.compareTo("2.1.0") < 0) {
                mappedGoal = null;
            }
        }
        if (mappedGoal != null) {
            goal = mappedGoal;
            if (parameterStr != null) {
                vmOptionList = new ParametersList();
                vmOptionList.addParametersString(settings.getVmOptions());
                vmOptionList.addProperty("grails.cli.args", parameterStr);
                settings.setVmOptions(vmOptionList.getParametersString());
            }
        } else if (command.getCommand() != null) {
            goal = "grails:exec";
            settings.getMavenProperties().put("command", command.getCommand());
            if (parameterStr != null) {
                settings.getMavenProperties().put("args", parameterStr);
            }
        }
        if (command.getProperties().size() > 0 || command.getEnv() != null) {
            vmOptionList = new ParametersList();
            vmOptionList.addParametersString(settings.getVmOptions());
            vmOptionList.addAll((List)command.getProperties());
            if (command.getEnv() != null) {
                vmOptionList.add("-Dgrails.env=" + command.getEnv());
            }
            settings.setVmOptions(vmOptionList.getParametersString());
        }
        MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
        MavenRunnerParameters parameters = new MavenRunnerParameters(true, workDir, goal == null ? Collections.emptyList() : Collections.singletonList(goal), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
        JavaParameters res = MavenExternalParameters.createJavaParameters((Project)module.getProject(), (MavenRunnerParameters)parameters, (MavenGeneralSettings)generalSettings, (MavenRunnerSettings)settings, null);
        MavenCommandExecutor.addCommonJvmOptions(res);
        return res;
    }

    @Override
    public JavaParameters createJavaParametersForRun(@NotNull Module module, boolean classpathFromDependencies, @Nullable Object additionalConfiguration, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParametersForRun"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParametersForRun"));
        }
        return MavenCommandExecutor.createJavaParameters(module, (MavenGeneralSettings)additionalConfiguration, command);
    }

    @Override
    public void addListener(JavaParameters params, String listener) {
        super.addListener(params, listener);
        MavenCommandExecutor.addAgentJar(params);
    }

    @Override
    public Pair<String, SettingsEditor<GrailsRunConfiguration>> createSettingsEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createSettingsEditor"));
        }
        return new Pair((Object)"Maven Settings", (Object)new GrailsMavenSettingsEditor(project));
    }

    @Override
    public Object readAdditionalConfiguration(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "readAdditionalConfiguration"));
        }
        Element e = element.getChild(MavenGeneralSettings.class.getSimpleName());
        if (e != null) {
            return XmlSerializer.deserialize((Element)e, MavenGeneralSettings.class);
        }
        return null;
    }

    @Override
    public void writeAdditionalConfiguration(@NotNull Object cfg, @NotNull Element element) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "writeAdditionalConfiguration"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "writeAdditionalConfiguration"));
        }
        MavenGeneralSettings settings = (MavenGeneralSettings)cfg;
        element.addContent(XmlSerializer.serialize((Object)settings));
    }

    @Override
    public Object cloneAdditionalConfiguration(@NotNull Object cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "cloneAdditionalConfiguration"));
        }
        return ((MavenGeneralSettings)cfg).clone();
    }

    private class GrailsMavenSettingsEditor
    extends SettingsEditor<GrailsRunConfiguration> {
        private final MavenGeneralSettingsEditor myDelegate;

        private GrailsMavenSettingsEditor(Project project) {
            this.myDelegate = new MavenGeneralSettingsEditor(project);
            Disposer.register((Disposable)this, (Disposable)this.myDelegate);
        }

        protected void resetEditorFrom(GrailsRunConfiguration s) {
            ConfigurationFactory factory = MavenRunConfigurationType.getInstance().getConfigurationFactories()[0];
            MavenRunConfiguration mavenRunConfiguration = (MavenRunConfiguration)factory.createTemplateConfiguration(this.myDelegate.getProject());
            mavenRunConfiguration.setGeneralSettings((MavenGeneralSettings)s.getAdditionalConfiguration(MavenCommandExecutor.this));
            this.myDelegate.resetFrom((Object)mavenRunConfiguration);
        }

        protected void applyEditorTo(GrailsRunConfiguration s) throws ConfigurationException {
            ConfigurationFactory factory = MavenRunConfigurationType.getInstance().getConfigurationFactories()[0];
            MavenRunConfiguration mavenRunConfiguration = (MavenRunConfiguration)factory.createTemplateConfiguration(this.myDelegate.getProject());
            mavenRunConfiguration.setGeneralSettings((MavenGeneralSettings)s.getAdditionalConfiguration(MavenCommandExecutor.this));
            this.myDelegate.applyTo((Object)mavenRunConfiguration);
            s.setAdditionalConfiguration(MavenCommandExecutor.this, mavenRunConfiguration.getGeneralSettings());
        }

        @NotNull
        protected JComponent createEditor() {
            JComponent jComponent = this.myDelegate.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor$GrailsMavenSettingsEditor", "createEditor"));
            }
            return jComponent;
        }
    }
}

