/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PlatformIcons;
import icons.GroovyMvcIcons;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.projectView.GrailsProjectViewState;
import org.jetbrains.plugins.grails.projectView.v2.nodes.leafs.ControllerClassNode;
import org.jetbrains.plugins.grails.projectView.v2.nodes.leafs.ViewNode;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.projectView.DomainClassNode;
import org.jetbrains.plugins.groovy.mvc.projectView.FileNode;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewState;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;
import org.jetbrains.plugins.groovy.mvc.projectView.TestsTopLevelDirectoryNode;
import org.jetbrains.plugins.groovy.mvc.projectView.TopLevelDirectoryNode;

public class GrailsToolWindowFactory
extends MvcToolWindowDescriptor {
    public GrailsToolWindowFactory() {
        super((MvcFramework)GrailsFramework.getInstance());
    }

    private static <R> void processChildren(@Nullable VirtualFile dir, Project project, List<R> result, Function<PsiDirectory, R> nodeCreator) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        for (VirtualFile child : dir.getChildren()) {
            Object fun;
            PsiDirectory psiDir;
            if (!child.isDirectory() || (psiDir = PsiManager.getInstance((Project)project).findDirectory(child)) == null || (fun = nodeCreator.fun((Object)psiDir)) == null) continue;
            result.add(fun);
        }
    }

    private static AbstractTreeNode processAppFolder(Module module, PsiDirectory directory, ViewSettings viewSettings) {
        String name = directory.getName();
        if ("domain".equals(name)) {
            return new TopLevelDirectoryNode(module, directory, viewSettings, "Domain classes", JetgroovyIcons.Mvc.ModelsNode, 20){

                protected AbstractTreeNode createClassNode(GrTypeDefinition typeDefinition) {
                    if (GrailsArtifact.DOMAIN.isInstance((PsiClass)typeDefinition)) {
                        return new DomainClassNode(this.getModule(), typeDefinition, this.getSettings());
                    }
                    return super.createClassNode(typeDefinition);
                }
            };
        }
        if ("controllers".equals(name)) {
            return new TopLevelDirectoryNode(module, directory, viewSettings, "Controllers", AllIcons.Nodes.KeymapTools, 30){

                protected AbstractTreeNode createClassNode(GrTypeDefinition typeDefinition) {
                    Module module = this.getModule();
                    if (GrailsArtifact.CONTROLLER.isInstance((PsiClass)typeDefinition)) {
                        return new ControllerClassNode(module, typeDefinition, this.getSettings());
                    }
                    return super.createClassNode(typeDefinition);
                }
            };
        }
        if ("views".equals(name)) {
            return new TopLevelDirectoryNode(module, directory, viewSettings, "Views", GroovyMvcIcons.Gsp_logo, 40){

                protected void processNotDirectoryFile(List<AbstractTreeNode> nodes, PsiFile file) {
                    if (((Object)((Object)GspFileType.GSP_FILE_TYPE)).equals(file.getFileType())) {
                        nodes.add((AbstractTreeNode)new ViewNode(this.getModule(), file, this.getSettings(), "VIEWS_SUBTREE"));
                    }
                }
            };
        }
        if ("conf".equals(name)) {
            return new TopLevelDirectoryNode(module, directory, viewSettings, "Configuration", JetgroovyIcons.Mvc.Config_folder_closed, 60);
        }
        if ("taglib".equals(name)) {
            return new TopLevelDirectoryNode(module, directory, viewSettings, "Taglibs", GroovyMvcIcons.Taglib, 90);
        }
        if ("services".equals(name)) {
            return new TopLevelDirectoryNode(module, directory, viewSettings, "Services", JetgroovyIcons.Mvc.Service, 50);
        }
        return new TopLevelDirectoryNode(module, directory, viewSettings, "grails-app/" + name, PlatformIcons.FOLDER_ICON, 64);
    }

    public void fillModuleChildren(List<AbstractTreeNode> result, final Module module, final ViewSettings viewSettings, VirtualFile root) {
        PsiFile psi;
        Project project = module.getProject();
        GrailsToolWindowFactory.processChildren(root.findChild("grails-app"), project, result, new NotNullFunction<PsiDirectory, AbstractTreeNode>(){

            @NotNull
            public AbstractTreeNode fun(PsiDirectory directory) {
                AbstractTreeNode abstractTreeNode = GrailsToolWindowFactory.processAppFolder(module, directory, viewSettings);
                if (abstractTreeNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory$4", "fun"));
                }
                return abstractTreeNode;
            }
        });
        PsiDirectory webApp = GrailsToolWindowFactory.findDirectory((Project)project, (VirtualFile)root, (String)"web-app");
        if (webApp != null) {
            result.add((AbstractTreeNode)new TopLevelDirectoryNode(module, webApp, viewSettings, "web-app", JavaeeIcons.WEB_FOLDER_CLOSED, 65));
        }
        GrailsToolWindowFactory.processChildren(root.findChild("src"), project, result, new NotNullFunction<PsiDirectory, AbstractTreeNode>(){

            @NotNull
            public AbstractTreeNode fun(PsiDirectory dir) {
                String name = dir.getName();
                Icon icon = "java".equals(name) ? StdFileTypes.JAVA.getIcon() : ("groovy".equals(name) ? JetgroovyIcons.Groovy.Groovy_16x16 : PlatformIcons.SOURCE_FOLDERS_ICON);
                TopLevelDirectoryNode topLevelDirectoryNode = new TopLevelDirectoryNode(module, dir, viewSettings, "Sources:" + name, icon, 70);
                if (topLevelDirectoryNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory$5", "fun"));
                }
                return topLevelDirectoryNode;
            }
        });
        PsiDirectory scriptsFolder = GrailsToolWindowFactory.findDirectory((Project)project, (VirtualFile)root, (String)"scripts");
        if (scriptsFolder != null) {
            result.add((AbstractTreeNode)new TopLevelDirectoryNode(module, scriptsFolder, viewSettings, "Scripts", JetgroovyIcons.Groovy.Gant_16x16, 70));
        }
        GrailsToolWindowFactory.processChildren(root.findChild("test"), project, result, new NotNullFunction<PsiDirectory, AbstractTreeNode>(){

            @NotNull
            public AbstractTreeNode fun(PsiDirectory dir) {
                String name = dir.getName();
                Icon icon = "unit".equals(name) ? PlatformIcons.TEST_SOURCE_FOLDER : ("integration".equals(name) ? GroovyMvcIcons.Grails_test : PlatformIcons.TEST_SOURCE_FOLDER);
                TestsTopLevelDirectoryNode testsTopLevelDirectoryNode = new TestsTopLevelDirectoryNode(module, dir, viewSettings, "Tests:" + name, icon, GroovyMvcIcons.Grails_test);
                if (testsTopLevelDirectoryNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory$6", "fun"));
                }
                return testsTopLevelDirectoryNode;
            }
        });
        VirtualFile appProps = root.findChild("application.properties");
        if (appProps != null && (psi = PsiManager.getInstance((Project)project).findFile(appProps)) != null) {
            result.add((AbstractTreeNode)new FileNode(module, psi, "application.properties", viewSettings));
        }
        for (VirtualFile file : root.getChildren()) {
            PsiFile psi2;
            if (!file.getName().endsWith("GrailsPlugin.groovy") || (psi2 = PsiManager.getInstance((Project)project).findFile(file)) == null) continue;
            result.add((AbstractTreeNode)new FileNode(module, psi2, null, viewSettings));
            break;
        }
        result.add((AbstractTreeNode)new PluginNode(viewSettings, module));
    }

    public Icon getModuleNodeIcon() {
        return GroovyMvcIcons.Grails_app;
    }

    @NotNull
    public MvcProjectViewState getProjectViewState(Project project) {
        MvcProjectViewState mvcProjectViewState = (MvcProjectViewState)ServiceManager.getService((Project)project, GrailsProjectViewState.class);
        if (mvcProjectViewState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory", "getProjectViewState"));
        }
        return mvcProjectViewState;
    }

    public boolean value(Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!GrailsStructure.isVersionAtLeast("3.0", module)) continue;
            return false;
        }
        return super.value(project);
    }

    public static class PluginNode
    extends ProjectViewNode<String> {
        private final ViewSettings myViewSettings;
        private final Module myModule;

        public PluginNode(ViewSettings viewSettings, Module module) {
            super(module.getProject(), (Object)"plugins", viewSettings);
            this.myViewSettings = viewSettings;
            this.myModule = module;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            MvcFramework framework = MvcFramework.getInstance((Module)this.myModule);
            if (framework == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory$PluginNode", "getChildren"));
                }
                return list;
            }
            Collection pluginRoots = framework.getCommonPluginRoots(this.myModule, false);
            ArrayList<TopLevelDirectoryNode> res = new ArrayList<TopLevelDirectoryNode>(pluginRoots.size());
            PsiManager manager = PsiManager.getInstance((Project)this.myModule.getProject());
            for (VirtualFile pluginRoot : pluginRoots) {
                PsiDirectory psiDirectory = manager.findDirectory(pluginRoot);
                if (psiDirectory == null) continue;
                res.add(new TopLevelDirectoryNode(this.myModule, psiDirectory, this.myViewSettings, pluginRoot.getName(), JetgroovyIcons.Mvc.Groovy_mvc_plugin, 100));
            }
            ArrayList<TopLevelDirectoryNode> arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory$PluginNode", "getChildren"));
            }
            return arrayList;
        }

        protected void update(PresentationData data) {
            data.setIcon(JetgroovyIcons.Mvc.Groovy_mvc_plugin);
            data.setPresentableText("Plugins");
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/projectView/GrailsToolWindowFactory$PluginNode", "contains"));
            }
            for (AbstractTreeNode abstractTreeNode : this.getChildren()) {
                TopLevelDirectoryNode topLevelNode = (TopLevelDirectoryNode)abstractTreeNode;
                if (!topLevelNode.contains(file)) continue;
                return true;
            }
            return false;
        }
    }
}

