/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GrailsFileReferenceSetBase
extends FileReferenceSet {
    public GrailsFileReferenceSetBase(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/plugins/grails/references/common/GrailsFileReferenceSetBase", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsFileReferenceSetBase", "<init>"));
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed);
    }

    @Nullable
    protected abstract VirtualFile getDefaultContext(boolean var1);

    @Nullable
    private PsiDirectory getDefaultContextPsiFile(boolean isAbsolute) {
        VirtualFile context = this.getDefaultContext(isAbsolute);
        if (context == null) {
            return null;
        }
        return this.getElement().getManager().findDirectory(context);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiDirectory res = this.getDefaultContextPsiFile(this.isAbsolutePathReference());
        List<Object> list = res == null ? Collections.emptyList() : Collections.singletonList(res);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/GrailsFileReferenceSetBase", "computeDefaultContexts"));
        }
        return list;
    }

    public RenamableFileReference createFileReference(TextRange range, int index, String text) {
        return new RenamableFileReference(this, range, index, text);
    }

    protected String makePathAbsolute(String path) {
        return '/' + path;
    }

    protected static class RenamableFileReference
    extends FileReference {
        public RenamableFileReference(@NotNull GrailsFileReferenceSetBase fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/plugins/grails/references/common/GrailsFileReferenceSetBase$RenamableFileReference", "<init>"));
            }
            super((FileReferenceSet)fileReferenceSet, range, index, text);
        }

        public RenamableFileReference(FileReference original) {
            super(original);
        }

        @NotNull
        public GrailsFileReferenceSetBase getFileReferenceSet() {
            GrailsFileReferenceSetBase grailsFileReferenceSetBase = (GrailsFileReferenceSetBase)super.getFileReferenceSet();
            if (grailsFileReferenceSetBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/GrailsFileReferenceSetBase$RenamableFileReference", "getFileReferenceSet"));
            }
            return grailsFileReferenceSetBase;
        }

        public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
            String path;
            PsiDirectory context;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/GrailsFileReferenceSetBase$RenamableFileReference", "bindToElement"));
            }
            if (!(element instanceof PsiFileSystemItem)) {
                throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element);
            }
            if (!absolute && (context = this.getFileReferenceSet().getDefaultContextPsiFile(false)) != null && (path = PsiFileSystemItemUtil.getRelativePathFromAncestor((PsiFileSystemItem)((PsiFileSystemItem)element), (PsiFileSystemItem)context)) != null) {
                return this.rename(path);
            }
            context = this.getFileReferenceSet().getDefaultContextPsiFile(true);
            if (context != null && (path = PsiFileSystemItemUtil.getRelativePathFromAncestor((PsiFileSystemItem)((PsiFileSystemItem)element), (PsiFileSystemItem)context)) != null) {
                return this.rename(this.getFileReferenceSet().makePathAbsolute(path));
            }
            return this.getElement();
        }
    }
}

