/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain.persistent;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.model.common.persistence.mapping.AttributeBase;
import com.intellij.javaee.model.common.persistence.mapping.PersistentObject;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.model.PersistenceInheritanceType;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.model.helpers.PersistentEntityModelHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.persistent.GormBasicAttribute;
import org.jetbrains.plugins.grails.references.domain.persistent.GormCollectionAttribute;
import org.jetbrains.plugins.grails.references.domain.persistent.GormEmbeddedAttribute;
import org.jetbrains.plugins.grails.references.domain.persistent.GormIdAttribute;
import org.jetbrains.plugins.grails.references.domain.persistent.GormPersistentAttribute;

public class GormEntity
extends CommonModelElement.PsiBase
implements PersistentEntity,
PersistentEntityModelHelper,
PersistentObject,
TableInfoProvider {
    private final Module myModule;
    private final PsiClass myDomainClass;
    private volatile List<AttributeBase> myAttributes;

    public GormEntity(Module module, PsiClass domainClass) {
        this.myModule = module;
        this.myDomainClass = domainClass;
    }

    public GenericValue<String> getName() {
        return ReadOnlyGenericValue.getInstance((Object)this.myDomainClass.getName());
    }

    public GenericValue<PsiClass> getClazz() {
        return ReadOnlyGenericValue.getInstance((Object)this.myDomainClass);
    }

    public List<? extends AttributeBase> getAllAttributes() {
        List<AttributeBase> res = this.myAttributes;
        if (res == null) {
            res = new ArrayList<AttributeBase>();
            DomainDescriptor descriptor = DomainDescriptor.getDescriptor(this.myDomainClass);
            for (Map.Entry<String, Pair<PsiType, PsiElement>> entry : descriptor.getPersistentProperties().entrySet()) {
                if (descriptor.isToManyRelation(entry.getKey())) {
                    res.add(new GormCollectionAttribute(this, entry.getKey(), (PsiType)entry.getValue().first, (PsiElement)entry.getValue().second));
                    continue;
                }
                GormPersistentAttribute attr = "id".equals(entry.getKey()) ? new GormIdAttribute(this, entry.getKey(), (PsiType)entry.getValue().first, (PsiElement)entry.getValue().second) : (descriptor.getEmbeddedPropertyNames().contains(entry.getKey()) ? new GormEmbeddedAttribute(this, entry.getKey(), (PsiType)entry.getValue().first, (PsiElement)entry.getValue().second) : new GormBasicAttribute(this, entry.getKey(), (PsiType)entry.getValue().first, (PsiElement)entry.getValue().second));
                res.add(attr);
            }
            this.myAttributes = res;
        }
        return res;
    }

    public AccessType getEffectiveAccessType() {
        return null;
    }

    public PersistentEntityModelHelper getObjectModelHelper() {
        return this;
    }

    public GenericValue<PsiClass> getIdClassValue() {
        return ReadOnlyGenericValue.nullInstance();
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myDomainClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/persistent/GormEntity", "getPsiElement"));
        }
        return psiClass;
    }

    public Module getModule() {
        return this.myModule;
    }

    public TableInfoProvider getTable() {
        return this;
    }

    public GenericValue<String> getTableName() {
        return ReadOnlyGenericValue.nullInstance();
    }

    public GenericValue<String> getCatalog() {
        return ReadOnlyGenericValue.nullInstance();
    }

    public GenericValue<String> getSchema() {
        return ReadOnlyGenericValue.nullInstance();
    }

    public List<? extends TableInfoProvider> getSecondaryTables() {
        return Collections.emptyList();
    }

    public PersistenceInheritanceType getInheritanceType(PersistentEntity descendant) {
        return null;
    }

    public List<? extends PersistenceQuery> getNamedQueries() {
        return Collections.emptyList();
    }

    public List<? extends PersistenceQuery> getNamedNativeQueries() {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends PersistentAttribute> getAttributes() {
        List<? extends AttributeBase> list = this.getAllAttributes();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/domain/persistent/GormEntity", "getAttributes"));
        }
        return list;
    }

    public PropertyMemberType getDefaultAccessMode() {
        return null;
    }

    public boolean isAccessModeFixed() {
        return false;
    }
}

