/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain.persistent;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.facet.HibernateFacetType;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.util.Collection;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GormHibernateFacetProvider
implements GrailsFacetProvider {
    @Override
    public void addFacets(Collection<Runnable> actions, final FacetManager facetManager, final Module module, Collection<VirtualFile> roots) {
        Collection hibernateFacets = facetManager.getFacetsByType(HibernateFacet.ID);
        Collection jpaFacets = facetManager.getFacetsByType(JpaFacet.ID);
        if (!hibernateFacets.isEmpty() || !jpaFacets.isEmpty()) {
            return;
        }
        actions.add(new Runnable(){

            @Override
            public void run() {
                VirtualFile hibernateDir;
                HibernateFacetType facetType = HibernateFacetType.getInstance();
                HibernateFacet facet = facetType.createFacet(module, "Hibernate", facetType.createDefaultConfiguration(), null);
                VirtualFile confDirectory = GrailsUtils.findConfDirectory(module);
                if (confDirectory != null && (hibernateDir = confDirectory.findChild("hibernate")) != null) {
                    ConfigFileInfoSet cfg = ((HibernateFacetConfiguration)facet.getConfiguration()).getDescriptorsConfiguration();
                    VirtualFile hibernateCfgXml = hibernateDir.findChild("hibernate.cfg.xml");
                    if (hibernateCfgXml != null) {
                        cfg.addConfigFile(new ConfigFileInfo(HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, hibernateCfgXml.getUrl()));
                    }
                }
                ModifiableFacetModel model = facetManager.createModifiableModel();
                model.addFacet((Facet)facet);
                model.commit();
            }
        });
    }
}

