/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GroovyGspTagWrapper;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.ResourceDirAttributeFileReferenceSet;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentReferenceProvider;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;

public class GspResourceDirAttributeSupport
extends TagAttributeReferenceProvider
implements GroovyNamedArgumentReferenceProvider {
    public static final String[] TAGS = new String[]{"resource", "createLinkTo"};

    public GspResourceDirAttributeSupport() {
        super("dir", "g", TAGS);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = GspResourceDirAttributeSupport.createReferences(element, gspTagWrapper);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] createReferences(@NotNull PsiElement element, final @NotNull GspTagWrapper gspTagWrapper) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "createReferences"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "createReferences"));
        }
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        TextRange range = manipulator.getRangeInElement(element);
        int offset = range.getStartOffset();
        String text = range.substring(element.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        if (trimedUrl.trim().length() == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        ResourceDirAttributeFileReferenceSet set = new ResourceDirAttributeFileReferenceSet(trimedUrl, element, offset, null, true, false){

            @Override
            protected PsiElement getPluginElement() {
                return gspTagWrapper.getAttributeValue("plugin");
            }

            @Override
            protected PsiElement getContextPathElement() {
                return gspTagWrapper.getAttributeValue("contextPath");
            }
        };
        return set.getAllReferences();
    }

    public PsiReference[] createRef(@NotNull PsiElement element, @NotNull GrNamedArgument namedArgument, @NotNull GroovyResolveResult resolveResult, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "createRef"));
        }
        if (namedArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedArgument", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "createRef"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "createRef"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/tagSupport/GspResourceDirAttributeSupport", "createRef"));
        }
        return GspResourceDirAttributeSupport.createReferences(element, new GroovyGspTagWrapper((GrNamedArgumentsOwner)namedArgument.getParent(), null));
    }
}

