/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.urlMappings;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.grails.references.MemberProvider;
import org.jetbrains.plugins.grails.references.urlMappings.UrlMappingUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public class UrlMappingMemberProvider
extends MemberProvider {
    private static final String URL_MAPPING_BUILDER = "org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingEvaluator.UrlMappingBuilder";

    @Override
    public void processMembers(PsiScopeProcessor processor, PsiClass psiClass, PsiElement place) {
        ClassHint classHint = (ClassHint)processor.getHint(ClassHint.KEY);
        if (classHint != null && !classHint.shouldProcess(ClassHint.ResolveKind.METHOD)) {
            return;
        }
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        GrClosableBlock closableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class);
        if (closableBlock == null) {
            return;
        }
        PsiClass urlMappingClass = GroovyPsiManager.getInstance((Project)psiClass.getProject()).findClassWithCache(URL_MAPPING_BUILDER, psiClass.getResolveScope());
        if (urlMappingClass == null) {
            return;
        }
        if (UrlMappingUtil.isMappingField(closableBlock)) {
            PsiMethod[] nameMethods;
            if ("group".equals(nameHint)) {
                for (PsiMethod method : nameMethods = urlMappingClass.findMethodsByName("group", true)) {
                    if (processor.execute((PsiElement)method, ResolveState.initial())) continue;
                    return;
                }
            }
            if ("name".equals(nameHint)) {
                for (PsiMethod method : nameMethods = urlMappingClass.findMethodsByName("name", true)) {
                    if (processor.execute((PsiElement)method, ResolveState.initial())) continue;
                    return;
                }
            }
        } else {
            PsiElement eMethodCall = closableBlock.getParent();
            if (eMethodCall instanceof GrArgumentList) {
                eMethodCall = eMethodCall.getParent();
            }
            if (eMethodCall instanceof GrMethodCall && UrlMappingUtil.isMappingDefinition((GrMethodCall)eMethodCall)) {
                if (!(nameHint != null && !nameHint.equals("constraints") || nameHint == null && UrlMappingMemberProvider.hasConstraintsBlock(closableBlock))) {
                    GrLightMethodBuilder builder = new GrLightMethodBuilder(psiClass.getManager(), "constraints");
                    builder.addParameter("closure", "groovy.lang.Closure", false);
                    if (!processor.execute((PsiElement)builder, ResolveState.initial())) {
                        return;
                    }
                }
                urlMappingClass.processDeclarations(processor, ResolveState.initial(), null, place);
            }
        }
    }

    private static boolean hasConstraintsBlock(GrClosableBlock block) {
        for (PsiElement e = block.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof GrMethodCall) || !PsiUtil.isReferenceWithoutQualifier((PsiElement)((GrMethodCall)e).getInvokedExpression(), (String)"constraints")) continue;
            return true;
        }
        return false;
    }
}

