/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.grails.GrailsInstallationCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcRunConfiguration;
import org.jetbrains.plugins.groovy.mvc.MvcRunConfigurationEditor;

class GrailsConfigurationEditor
extends MvcRunConfigurationEditor<GrailsRunConfiguration> {
    private final JCheckBox myLaunchBrowser = new JCheckBox("Launch browser");
    private boolean myDepClassPathAvailable;

    GrailsConfigurationEditor() {
        this.myModulesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GrailsConfigurationEditor.this.moduleChanged();
            }
        });
        this.addExtension(this.myLaunchBrowser);
    }

    protected void commandLineChanged(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "org/jetbrains/plugins/grails/runner/GrailsConfigurationEditor", "commandLineChanged"));
        }
        super.commandLineChanged(newText);
        GrailsConfigurationEditor.setCBEnabled((boolean)newText.contains("run-app"), (JCheckBox)this.myLaunchBrowser);
    }

    protected boolean isAvailableDepsClasspath() {
        return this.myDepClassPathAvailable;
    }

    protected void resetEditorFrom(GrailsRunConfiguration configuration) {
        super.resetEditorFrom((MvcRunConfiguration)configuration);
        this.myLaunchBrowser.setSelected(configuration.isLaunchBrowser());
    }

    protected void applyEditorTo(GrailsRunConfiguration configuration) throws ConfigurationException {
        super.applyEditorTo((MvcRunConfiguration)configuration);
        configuration.setLaunchBrowser(this.myLaunchBrowser.isSelected());
    }

    private void moduleChanged() {
        Module module = this.getSelectedModule();
        GrailsCommandExecutor executor = module == null ? null : GrailsUtils.getGrailsExecutor(module);
        this.myDepClassPathAvailable = executor instanceof GrailsInstallationCommandExecutor;
        this.commandLineChanged(this.getCommandLine());
    }
}

