/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;

public class GrailsDebuggerRunner
extends GenericDebuggerRunner {
    public static final String ID = GrailsDebuggerRunner.class.getSimpleName();

    @NotNull
    public String getRunnerId() {
        String string = ID;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "getRunnerId"));
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "canRun"));
        }
        if (profile instanceof GrailsRunConfiguration && DefaultDebugExecutor.EXECUTOR_ID.equals(executorId)) {
            GrailsRunConfiguration runConfiguration = (GrailsRunConfiguration)profile;
            Module module = runConfiguration.getModule();
            return !ExternalSystemApiUtil.isExternalSystemAwareModule((String)"GRADLE", (Module)module);
        }
        return false;
    }

    boolean isForked(GrailsRunConfiguration configuration) throws ExecutionException {
        Module module = configuration.getModule();
        if (module == null) {
            throw new ExecutionException("Module is not specified");
        }
        GrailsStructure structure = GrailsStructure.getInstance(module);
        boolean forTests = configuration.isForTests(module);
        return structure != null && (forTests ? structure.isAtLeastGrails("2.3.10") && GrailsSettingsService.isDebugTestForked(module) : structure.isAtLeastGrails("2.3.5") && GrailsSettingsService.isDebugRunForked(module));
    }

    @Nullable
    protected RunContentDescriptor createContentDescriptor(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "createContentDescriptor"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/GrailsDebuggerRunner", "createContentDescriptor"));
        }
        if (environment.getRunProfile() instanceof GrailsRunConfiguration && this.isForked((GrailsRunConfiguration)environment.getRunProfile())) {
            String address = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
            String forkedInstanceArgs = String.format("-Xrunjdwp:transport=dt_socket,server=n,suspend=n,address=%s", address);
            ParametersList vmParametersList = ((JavaCommandLine)state).getJavaParameters().getVMParametersList();
            vmParametersList.addProperty("grails.project.fork.run.debugArgs", forkedInstanceArgs);
            vmParametersList.addProperty("grails.project.fork.test.debugArgs", forkedInstanceArgs);
            return this.attachVirtualMachine(state, environment, new RemoteConnection(true, "127.0.0.1", address, true), true);
        }
        return super.createContentDescriptor(state, environment);
    }
}

