/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.gradle.GrailsGradleInvoker;
import org.jetbrains.plugins.grails.runner.GrailsConfigurationEditor;
import org.jetbrains.plugins.grails.runner.GrailsConfigurationFactory;
import org.jetbrains.plugins.grails.runner.GrailsRerunFailedTestsAction;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcRunConfiguration;

public class GrailsRunConfiguration
extends MvcRunConfiguration
implements RunConfigurationWithSuppressedDefaultDebugAction {
    private static final String FRAMEWORK_NAME = "GrailsTests";
    private static final String GRAILS_LISTENER_NAME = "org.jetbrains.groovy.grails.rt.GrailsIdeaTestListener";
    @NonNls
    private static final String GRAILS_DISABLE_AUTO_RECOMPILE = "-Ddisable.auto.recompile=";
    @NonNls
    private static final String GRAILS_RECOMPILE_FREQ = "-Drecompile.frequency=";
    @NonNls
    private static final String GRAILS_SERVER_PORT = "-Dserver.port=";
    @NonNls
    private static final String GRAILS_SERVER_HOST = "-Dserver.host=";
    @NonNls
    private static final String GRAILS_ENABLE_JNDI = "-Denable.jndi=";
    @NonNls
    public static final String SERVER_RUNNING_BROWSE_TO = "Server running. Browse to ";
    private final Map<GrailsCommandExecutor, Object> myAdditionalConfiguration = new HashMap<GrailsCommandExecutor, Object>();
    private final GrailsConfigurationFactory factory;
    private boolean myLaunchBrowser = false;

    public GrailsRunConfiguration(GrailsConfigurationFactory factory, Project project, String name, String cmdLine) {
        super(name, new RunConfigurationModule(project), (ConfigurationFactory)factory, (MvcFramework)GrailsFramework.getInstance());
        this.factory = factory;
        this.cmdLine = cmdLine;
        this.depsClasspath = false;
    }

    @NotNull
    public SettingsEditor<GrailsRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor("Grails", (SettingsEditor)new GrailsConfigurationEditor());
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        for (GrailsCommandExecutor executor : (GrailsCommandExecutor[])GrailsCommandExecutor.EP_NAME.getExtensions()) {
            Pair<String, SettingsEditor<GrailsRunConfiguration>> pair = executor.createSettingsEditor(this.getProject());
            if (pair == null) continue;
            group.addEditor((String)pair.first, (SettingsEditor)pair.second);
        }
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public boolean isLaunchBrowser() {
        return this.myLaunchBrowser;
    }

    public void setLaunchBrowser(boolean launchBrowser) {
        this.myLaunchBrowser = launchBrowser;
    }

    public <T> T getAdditionalConfiguration(GrailsCommandExecutor executor) {
        return (T)this.myAdditionalConfiguration.get(executor);
    }

    public void setAdditionalConfiguration(GrailsCommandExecutor executor, Object cfg) {
        this.myAdditionalConfiguration.put(executor, cfg);
    }

    public void readExternal(Element element) throws InvalidDataException {
        String recFreq;
        boolean jndi;
        boolean disableAutorecomp;
        String portik;
        String hostik;
        super.readExternal(element);
        this.myLaunchBrowser = !"false".equals(JDOMExternalizer.readString((Element)element, (String)"launchBrowser"));
        for (GrailsCommandExecutor grailsCommandExecutor : (GrailsCommandExecutor[])GrailsCommandExecutor.EP_NAME.getExtensions()) {
            Object cfg = grailsCommandExecutor.readAdditionalConfiguration(element);
            if (cfg == null) continue;
            this.setAdditionalConfiguration(grailsCommandExecutor, cfg);
        }
        if (StringUtil.isNotEmpty((String)this.cmdLine)) {
            return;
        }
        String testNames = JDOMExternalizer.readString((Element)element, (String)"names");
        if (testNames != null) {
            this.cmdLine = "test-app";
            int testType = JDOMExternalizer.readInteger((Element)element, (String)"type", (int)0);
            if (testType == 1) {
                this.cmdLine = this.cmdLine + " -integration";
            } else if (testType == 2) {
                this.cmdLine = this.cmdLine + " -unit";
            }
            if (StringUtil.isNotEmpty((String)testNames)) {
                this.cmdLine = this.cmdLine + " " + testNames;
            }
            return;
        }
        this.cmdLine = "run-app";
        String grailsParams = JDOMExternalizer.readString((Element)element, (String)"grailsparams");
        if (StringUtil.isNotEmpty((String)grailsParams)) {
            this.cmdLine = this.cmdLine + " " + grailsParams.trim();
        }
        if (StringUtil.isNotEmpty((String)(hostik = JDOMExternalizer.readString((Element)element, (String)"hostik"))) && !hostik.equals(GrailsUtils.GRAILS_RUN_DEFAULT_HOST)) {
            this.cmdLine = this.cmdLine + " -Dserver.host=" + hostik;
        }
        if (StringUtil.isNotEmpty((String)(portik = JDOMExternalizer.readString((Element)element, (String)"port"))) && !portik.equals(GrailsUtils.GRAILS_RUN_DEFAULT_PORT)) {
            this.cmdLine = this.cmdLine + " -Dserver.port=" + portik;
        }
        if (disableAutorecomp = JDOMExternalizer.readBoolean((Element)element, (String)"recomp")) {
            this.cmdLine = this.cmdLine + " -Ddisable.auto.recompile=true";
        }
        if (jndi = JDOMExternalizer.readBoolean((Element)element, (String)"jndi")) {
            this.cmdLine = this.cmdLine + " -Denable.jndi=true";
        }
        if (StringUtil.isNotEmpty((String)(recFreq = JDOMExternalizer.readString((Element)element, (String)"recompileFreq"))) && !"3".equals(recFreq)) {
            this.cmdLine = this.cmdLine + " -Drecompile.frequency=" + recFreq;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.write((Element)element, (String)"launchBrowser", (boolean)this.myLaunchBrowser);
        for (Map.Entry<GrailsCommandExecutor, Object> entry : this.myAdditionalConfiguration.entrySet()) {
            Object cfg = entry.getValue();
            if (cfg == null) continue;
            entry.getKey().writeAdditionalConfiguration(cfg, element);
        }
    }

    protected String getNoSdkMessage() {
        return "Grails SDK is not configured";
    }

    protected ModuleBasedConfiguration createInstance() {
        GrailsRunConfiguration res = new GrailsRunConfiguration(this.factory, this.getConfigurationModule().getProject(), this.getName(), this.cmdLine);
        res.envs.putAll(this.envs);
        res.passParentEnv = this.passParentEnv;
        for (Map.Entry<GrailsCommandExecutor, Object> entry : this.myAdditionalConfiguration.entrySet()) {
            Object cfg = entry.getValue();
            if (cfg == null) continue;
            GrailsCommandExecutor executor = entry.getKey();
            res.setAdditionalConfiguration(executor, executor.cloneAdditionalConfiguration(cfg));
        }
        return res;
    }

    protected RunProfileState createCommandLineState(@NotNull ExecutionEnvironment environment, @NotNull Module module) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration", "createCommandLineState"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration", "createCommandLineState"));
        }
        if (GrailsConfigUtils.isGradleGrailsIntegration(module)) {
            return new MyGradleRunProfileState(module);
        }
        return new GrailsCommandLineState(environment, module, this.isForTests(module) && GrailsConfigUtils.isAtLeastGrails1_2(module));
    }

    public boolean isForTests(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration", "isForTests"));
        }
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((String)"GRADLE", (Module)module)) {
            return false;
        }
        return this.cmdLine != null && this.cmdLine.matches("\\s*(-D[^\\s]+\\s+)*test-app(\\s.*)?");
    }

    protected boolean isSupport(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration", "isSupport"));
        }
        return GrailsUtils.hasSupport(module);
    }

    private String getTrimmedGrailsCmdLine() {
        return StringUtil.trimStart((String)this.cmdLine.trim(), (String)"grails").trim();
    }

    public static int getGrailsConsolePrefixLength(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration", "getGrailsConsolePrefixLength"));
        }
        if (line.startsWith("|")) {
            if (line.startsWith("| ")) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public class MyGradleRunProfileState
    implements RunProfileState {
        private final Module myModule;

        public MyGradleRunProfileState(Module module) {
            this.myModule = module;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration$MyGradleRunProfileState", "execute"));
            }
            String myCmdLine = GrailsRunConfiguration.this.getTrimmedGrailsCmdLine();
            MvcCommand command = MvcCommand.parse((String)myCmdLine, null);
            new GrailsGradleInvoker(this.myModule).invoke(executor.getId(), GrailsRunConfiguration.this.getName(), command, null);
            return null;
        }
    }

    public class GrailsCommandLineState
    extends MvcRunConfiguration.MvcCommandLineState {
        private GrailsCommandExecutor myExecutor;

        public GrailsCommandLineState(ExecutionEnvironment environment, Module module, boolean forTests) {
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration$GrailsCommandLineState", "<init>"));
            }
            super((MvcRunConfiguration)GrailsRunConfiguration.this, environment, GrailsRunConfiguration.this.getTrimmedGrailsCmdLine(), module, forTests);
            this.myExecutor = GrailsUtils.getGrailsExecutor(module);
            assert (this.myExecutor != null);
        }

        public GrailsCommandExecutor getExecutor() {
            return this.myExecutor;
        }

        protected JavaParameters createJavaParametersMVC() throws ExecutionException {
            String runnerId;
            Map env;
            MvcCommand cmd = MvcCommand.parse((String)this.myCmdLine, (String)GrailsRunConfiguration.this.vmParams);
            JavaParameters params = this.myExecutor.createJavaParametersForRun(this.myModule, GrailsRunConfiguration.this.depsClasspath, GrailsRunConfiguration.this.myAdditionalConfiguration.get(this.myExecutor), cmd);
            VirtualFile root = GrailsFramework.getInstance().findAppRoot(this.myModule);
            if (root == null) {
                throw new ExecutionException("Cannot find application root");
            }
            params.setWorkingDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)root));
            if (this.myForTests && GrailsConfigUtils.isAtLeastGrails1_2(this.myModule)) {
                this.myExecutor.addListener(params, GrailsRunConfiguration.GRAILS_LISTENER_NAME);
            }
            this.addEnvVars(params);
            if (DefaultDebugExecutor.getDebugExecutorInstance().equals(this.getEnvironment().getExecutor()) && GrailsConfigUtils.isAtLeastGrails(this.myModule, "1.3.4") && GrailsConfigUtils.isGrailsLessThan(this.myModule, "3.0") && !(env = params.getEnv()).containsKey("GROOVY_PAGE_ADD_LINE_NUMBERS")) {
                env.put("GROOVY_PAGE_ADD_LINE_NUMBERS", "true");
            }
            if ("Debug".equals(runnerId = this.getEnvironment().getRunner().getRunnerId()) && GrailsConfigUtils.isAtLeastGrails2_0(this.myModule)) {
                GrailsUtils.addSystemPropertyIfNotExists(params.getVMParametersList(), "-Dgrails.full.stacktrace=true");
            }
            return params;
        }

        @NotNull
        public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration$GrailsCommandLineState", "execute"));
            }
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration$GrailsCommandLineState", "execute"));
            }
            if (this.myForTests) {
                OSProcessHandler processHandler = this.startProcess();
                SMTRunnerConsoleProperties properties = new SMTRunnerConsoleProperties((RunConfiguration)GrailsRunConfiguration.this, GrailsRunConfiguration.FRAMEWORK_NAME, executor);
                final SMTRunnerConsoleView consoleView = (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createAndAttachConsole((String)GrailsRunConfiguration.FRAMEWORK_NAME, (ProcessHandler)processHandler, (TestConsoleProperties)properties);
                PrintStream ps = new PrintStream(processHandler.getProcessInput());
                ps.print("n\nn\nn\nn\nn\nn\nn\nn\nn\nn\n");
                ps.flush();
                GrailsRerunFailedTestsAction rerunFailedTestsAction = new GrailsRerunFailedTestsAction((ComponentContainer)consoleView, consoleView.getProperties());
                rerunFailedTestsAction.setModelProvider((Getter)new Getter<TestFrameworkRunningModel>(){

                    public TestFrameworkRunningModel get() {
                        return consoleView.getResultsViewer();
                    }
                });
                DefaultExecutionResult result = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler, this.createActions((ConsoleView)consoleView, (ProcessHandler)processHandler));
                result.setRestartActions(new AnAction[]{rerunFailedTestsAction});
                DefaultExecutionResult defaultExecutionResult = result;
                if (defaultExecutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration$GrailsCommandLineState", "execute"));
                }
                return defaultExecutionResult;
            }
            ExecutionResult result = super.execute(executor, runner);
            final ProcessHandler handler = result.getProcessHandler();
            if (handler != null && GrailsRunConfiguration.this.myLaunchBrowser) {
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        int start;
                        String s = event.getText().trim();
                        if (s.startsWith(GrailsRunConfiguration.SERVER_RUNNING_BROWSE_TO, start = GrailsRunConfiguration.getGrailsConsolePrefixLength(s))) {
                            String url = s.substring(start + GrailsRunConfiguration.SERVER_RUNNING_BROWSE_TO.length()).trim();
                            int space = url.indexOf(32);
                            if (space >= 0) {
                                url = url.substring(0, space);
                            }
                            BrowserUtil.browse((String)url);
                            handler.removeProcessListener((ProcessListener)this);
                        }
                    }
                });
            }
            ExecutionResult executionResult = result;
            if (executionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/runner/GrailsRunConfiguration$GrailsCommandLineState", "execute"));
            }
            return executionResult;
        }
    }
}

