/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.Location;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsAbstractConfigurationProducer;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;

public class GrailsScriptRunConfigurationProducer
extends GrailsAbstractConfigurationProducer {
    @Nullable
    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        MvcFramework framework = MvcFramework.getInstance((Module)module);
        if (!(framework instanceof GrailsFramework)) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        if (!(element instanceof GroovyFile)) {
            return null;
        }
        GroovyFile file = (GroovyFile)element;
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile scriptDir = virtualFile.getParent();
        if (scriptDir == null || !"scripts".equals(scriptDir.getName())) {
            return null;
        }
        if (!file.isScript() || !MvcFramework.isScriptFileName((String)virtualFile.getName())) {
            return null;
        }
        if (!Comparing.equal((Object)framework.findAppRoot(module), (Object)scriptDir.getParent())) {
            return null;
        }
        String scriptName = virtualFile.getNameWithoutExtension();
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)module.getProject()).createConfiguration("", this.getConfigurationFactory());
        GrailsRunConfiguration configuration = (GrailsRunConfiguration)settings.getConfiguration();
        configuration.cmdLine = GroovyNamesUtil.camelToSnake((String)scriptName);
        configuration.setModule(module);
        configuration.setName(scriptName);
        this.mySourceElement = file;
        return settings;
    }
}

