/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsInjectedTraitService {
    private static final Logger LOG = Logger.getInstance(GrailsInjectedTraitService.class);
    private static final Key<MultiMap<String, String>> TRAITS_KEY = new Key("grails.injected.traits");
    private static final String MARKER = "--------------------------------------";
    private static final Map<GrailsArtifact, String> ARTEFACT_TO_NAME = ContainerUtil.newHashMap((Pair)Pair.create((Object)((Object)GrailsArtifact.DOMAIN), (Object)"Domain"), (Pair[])new Pair[]{Pair.create((Object)((Object)GrailsArtifact.CONTROLLER), (Object)"Controller"), Pair.create((Object)((Object)GrailsArtifact.SERVICE), (Object)"Service"), Pair.create((Object)((Object)GrailsArtifact.INTERCEPTOR), (Object)"Interceptor"), Pair.create((Object)((Object)GrailsArtifact.TAGLIB), (Object)"TagLibrary")});
    @NotNull
    private final Project myProject;
    private final BackgroundTaskQueue myTaskQueue;
    private final AtomicReference<ProgressIndicator> myCurrentIndicator;
    private final AtomicBoolean myIsQueuing;

    public GrailsInjectedTraitService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "<init>"));
        }
        this.myCurrentIndicator = new AtomicReference();
        this.myIsQueuing = new AtomicBoolean(false);
        this.myProject = project;
        this.myTaskQueue = new BackgroundTaskQueue(project, "Grails service task queue");
    }

    public void queueUpdate() {
        if (!ContainerUtil.or((Object[])ModuleManager.getInstance((Project)this.myProject).getModules(), GrailsConfigUtils.IS_GRAILS3_MODULE)) {
            return;
        }
        if (this.myIsQueuing.getAndSet(true)) {
            LOG.debug("Already queued/queuing for " + this.myProject + ", returning");
            return;
        }
        ProgressIndicator oldIndicator = this.myCurrentIndicator.getAndSet(null);
        if (oldIndicator != null) {
            oldIndicator.cancel();
            LOG.debug(oldIndicator.toString());
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GrailsInjectedTraitService.this.myTaskQueue.clear();
                GrailsInjectedTraitService.this.myTaskQueue.run((Task.Backgroundable)new UpdateProjectTraitsTask());
                LOG.debug("Update queued for " + GrailsInjectedTraitService.this.myProject);
            }
        }, this.myProject.getDisposed());
    }

    @NotNull
    public MultiMap<String, String> getCachedMap(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getCachedMap"));
        }
        ProgressManager.checkCanceled();
        MultiMap data = (MultiMap)module.getUserData(TRAITS_KEY);
        MultiMap multiMap = data == null ? MultiMap.empty() : data;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getCachedMap"));
        }
        return multiMap;
    }

    @NotNull
    public static Collection<String> getInjectedTraits(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInjectedTraits"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        if (module == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInjectedTraits"));
            }
            return list;
        }
        GrailsInjectedTraitService service = GrailsInjectedTraitService.getInstance(module.getProject());
        String artefactName = ARTEFACT_TO_NAME.get((Object)GrailsArtifact.getType((PsiClass)clazz));
        Collection collection = service.getCachedMap(module).get((Object)artefactName);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInjectedTraits"));
        }
        return collection;
    }

    @NotNull
    public static GrailsInjectedTraitService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInstance"));
        }
        GrailsInjectedTraitService grailsInjectedTraitService = (GrailsInjectedTraitService)ServiceManager.getService((Project)project, GrailsInjectedTraitService.class);
        if (grailsInjectedTraitService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "getInstance"));
        }
        return grailsInjectedTraitService;
    }

    @NotNull
    private static MultiMap<String, String> doCollectInjectedTraits(@NotNull ProgressIndicator indicator, final @NotNull Module module) throws ExecutionException {
        MultiMap<String, String> multiMap;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
        }
        indicator.checkCanceled();
        indicator.setText(GrailsBundle.message("grails.collecting.traits.text", module.getName()));
        GeneralCommandLine command = (GeneralCommandLine)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<GeneralCommandLine, ExecutionException>(){

            public GeneralCommandLine compute() throws ExecutionException {
                if (module.isDisposed() || ModuleRootManager.getInstance((Module)module).getSdk() == null) {
                    return null;
                }
                if (!GrailsUtils.hasSupport(module) || !GrailsStructure.isVersionAtLeast("3.0", module)) {
                    return null;
                }
                return GrailsFramework.getInstance().createCommand(module, false, new MvcCommand("idea-list-injected-traits", new String[0]));
            }
        });
        if (command == null) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
            }
            return multiMap2;
        }
        indicator.checkCanceled();
        final StringBuilder outputBuilder = new StringBuilder();
        OSProcessHandler handler = new OSProcessHandler(command);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                    outputBuilder.append(StringUtil.convertLineSeparators((String)event.getText()));
                }
            }
        });
        handler.startNotify();
        while (!handler.waitFor(300L)) {
            if (!indicator.isCanceled()) continue;
            handler.destroyProcess();
            break;
        }
        indicator.checkCanceled();
        String output = outputBuilder.toString();
        LOG.debug(output);
        try {
            multiMap = GrailsInjectedTraitService.doParseOutput(output);
        }
        catch (AssertionError e) {
            LOG.debug((Throwable)((Object)e));
            MultiMap multiMap3 = MultiMap.empty();
            if (multiMap3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
            }
            return multiMap3;
        }
        catch (NoSuchElementException e) {
            LOG.debug((Throwable)e);
            MultiMap multiMap4 = MultiMap.empty();
            if (multiMap4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
            }
            return multiMap4;
        }
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doCollectInjectedTraits"));
        }
        return multiMap;
    }

    @NotNull
    private static MultiMap<String, String> doParseOutput(String output) {
        MultiMap result = MultiMap.create();
        LinkedList lines = ContainerUtil.newLinkedList((Object[])output.split("\n"));
        while (!((String)lines.pop()).equals(MARKER)) {
        }
        while (lines.size() > 1) {
            String traitName = (String)lines.pop();
            int artifactCount = Integer.parseInt((String)lines.pop());
            while (artifactCount-- > 0) {
                String artifactName = (String)lines.pop();
                result.putValue((Object)artifactName, (Object)traitName);
            }
        }
        assert (((String)lines.pop()).equals(MARKER));
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService", "doParseOutput"));
        }
        return multiMap;
    }

    private abstract class UpdateTraitsTask
    extends Task.Backgroundable {
        private UpdateTraitsTask() {
            super(GrailsInjectedTraitService.this.myProject, GrailsBundle.message("grails.collecting.traits.title", new Object[0]), true, ALWAYS_BACKGROUND);
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService$UpdateTraitsTask", "run"));
            }
            try {
                if (this.myProject.isDisposed()) {
                    return;
                }
                GrailsInjectedTraitService.this.myCurrentIndicator.set(indicator);
                GrailsInjectedTraitService.this.myIsQueuing.set(false);
                this.doRun(indicator);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                GrailsInjectedTraitService.this.myCurrentIndicator.set(null);
            }
        }

        protected abstract void doRun(@NotNull ProgressIndicator var1) throws Exception;

        public final void onSuccess() {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private class UpdateProjectTraitsTask
    extends UpdateTraitsTask {
        private UpdateProjectTraitsTask() {
        }

        @Override
        protected void doRun(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/settings/GrailsInjectedTraitService$UpdateProjectTraitsTask", "doRun"));
            }
            for (Module module : ModuleManager.getInstance((Project)this.getProject()).getModules()) {
                module.putUserData(TRAITS_KEY, (Object)GrailsInjectedTraitService.doCollectInjectedTraits(indicator, module));
            }
        }
    }
}

