/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.service.GrailsSettingsListener;
import org.jetbrains.plugins.grails.settings.GrailsSDKHomeForm;

public class GrailsProjectConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final Project myProject;
    @NotNull
    private final PropertiesComponent myPropertiesComponent;
    private GrailsSDKHomeForm myForm;

    public GrailsProjectConfigurable(@NotNull Project project, @NotNull PropertiesComponent component) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsProjectConfigurable", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/plugins/grails/settings/GrailsProjectConfigurable", "<init>"));
        }
        this.myProject = project;
        this.myPropertiesComponent = component;
    }

    @NotNull
    public String getId() {
        if ("grails.project.settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsProjectConfigurable", "getId"));
        }
        return "grails.project.settings";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Grails";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myForm == null) {
            this.myForm = new GrailsSDKHomeForm(this.myProject).setPath(this.myPropertiesComponent.getValue("grails.sdk.home"));
        }
        return this.myForm.getComponent();
    }

    public boolean isModified() {
        String selected;
        String existing = this.myPropertiesComponent.getValue("grails.sdk.home");
        return !Comparing.equal((String)existing, (String)(selected = StringUtil.nullize((String)this.myForm.getPath(), (boolean)true)));
    }

    public void apply() throws ConfigurationException {
        if (this.myForm.validate()) {
            this.myPropertiesComponent.setValue("grails.sdk.home", StringUtil.nullize((String)this.myForm.getPath(), (boolean)true));
            ((GrailsSettingsListener)this.myProject.getMessageBus().syncPublisher(GrailsSettingsListener.LISTENER_TOPIC)).onSDKHomeChange();
        }
    }

    public void reset() {
        this.myForm.setPath(this.myPropertiesComponent.getValue("grails.sdk.home"));
    }

    public void disposeUIResources() {
    }
}

