/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.settings;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;

public class GrailsSDKHomeForm {
    private static final FileChooserDescriptor FILE_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(false, true, false, false, false, false){

        public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
            return super.isFileVisible(file, showHiddenFiles) && file.isDirectory();
        }

        public void validateSelectedFiles(VirtualFile[] files) throws Exception {
            assert (files.length == 1);
            VirtualFile file = files[0];
            String version = GrailsConfigUtils.getInstance().getSDKVersion(file.getPath());
            if (version == "undefined" || VersionComparatorUtil.compare((String)version, (String)"3.0") < 0) {
                throw new Exception(ProjectBundle.message((String)(file.isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error"), (Object[])new Object[]{"Grails 3 SDK"}));
            }
        }
    }.withShowHiddenFiles(true);
    private JPanel myComponent;
    private TextFieldWithBrowseButton myPath;
    private JBLabel myVersionLabel;
    @Nullable
    private final Project myProject;

    public GrailsSDKHomeForm(@Nullable Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPath.addBrowseFolderListener(new TextBrowseFolderListener(FILE_CHOOSER_DESCRIPTOR){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "org/jetbrains/plugins/grails/settings/GrailsSDKHomeForm$2", "onFileChosen"));
                }
                super.onFileChosen(chosenFile);
                GrailsSDKHomeForm.this.validate();
            }

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file = super.getInitialFile();
                if (file != null) {
                    return file;
                }
                VirtualFile gvmCurrent = VfsUtil.findRelativeFile((VirtualFile)VfsUtil.getUserHomeDir(), (String[])new String[]{".gvm", "grails", "current"});
                if (gvmCurrent != null) {
                    return gvmCurrent;
                }
                return VfsUtil.findRelativeFile((VirtualFile)VfsUtil.getUserHomeDir(), (String[])new String[]{".sdkman", "grails", "current"});
            }
        });
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getPath() {
        return this.myPath.getText();
    }

    public GrailsSDKHomeForm setPath(String path) {
        this.myPath.setText(path);
        this.validate();
        return this;
    }

    public GrailsSDKHomeForm setEditable(boolean editable) {
        this.myPath.setEditable(editable);
        this.myPath.setButtonEnabled(editable);
        return this;
    }

    public boolean validate() {
        String path = this.getPath();
        if (StringUtil.isEmpty((String)path)) {
            return this.error("Grails SDK is not selected");
        }
        String version = GrailsConfigUtils.getInstance().getSDKVersion(path);
        if (version == "undefined") {
            return this.error("Cannot determine Grails SDK version");
        }
        if (VersionComparatorUtil.compare((String)version, (String)"3.0") >= 0) {
            Collection<Pair<Module, String>> modulesAndVersions = this.computeDifferentGrailsVersions(version);
            if (modulesAndVersions.isEmpty()) {
                return this.message("Grails SDK version " + version, false);
            }
            return this.message(String.format("Grails SDK version %s is different for %s", version, StringUtil.join(modulesAndVersions, (Function)new Function<Pair<Module, String>, String>(){

                public String fun(Pair<Module, String> pair) {
                    return String.format("%s (%s)", ((Module)pair.first).getName(), pair.second);
                }
            }, (String)", ")), false);
        }
        return this.error("Grails SDK version must be at least 3.x");
    }

    private boolean error(String message) {
        return this.message(message, true);
    }

    private boolean message(String message, boolean isError) {
        this.myVersionLabel.setText("<html>" + message + "</html>");
        this.myVersionLabel.setForeground((Color)(isError ? JBColor.RED : JBColor.foreground()));
        return !isError;
    }

    @NotNull
    private Collection<Pair<Module, String>> computeDifferentGrailsVersions(final String selectedVersion) {
        if (this.myProject == null) {
            List<Pair<Module, String>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsSDKHomeForm", "computeDifferentGrailsVersions"));
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Object[])ModuleManager.getInstance((Project)this.myProject).getModules(), (Function)new Function<Module, Pair<Module, String>>(){

            public Pair<Module, String> fun(Module module) {
                String versionFromDependencies = GrailsConfigUtils.getGrailsVersion(module);
                if (versionFromDependencies == null) {
                    return null;
                }
                if (VersionComparatorUtil.compare((String)versionFromDependencies, (String)selectedVersion) == 0) {
                    return null;
                }
                return Pair.create((Object)module, (Object)versionFromDependencies);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/settings/GrailsSDKHomeForm", "computeDifferentGrailsVersions"));
        }
        return list;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Grails SDK Home:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 3, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        jBLabel.setEnabled(true);
        jBLabel.setVisible(true);
        jBLabel.setText("");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 1, 1, 0, 6, null, new Dimension(500, -1), null, 1));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

