/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.settings;

import com.intellij.ProjectTopics;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.service.GrailsSettingsListener;
import org.jetbrains.plugins.grails.settings.GrailsInjectedTraitService;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public class GrailsStartupActivity
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsStartupActivity", "runActivity"));
        }
        if (project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE) {
            GrailsConfigUtils.checkGrailsShellConfigured(project);
        }
        final GrailsInjectedTraitService instance = GrailsInjectedTraitService.getInstance(project);
        instance.queueUpdate();
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/settings/GrailsStartupActivity$1", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/settings/GrailsStartupActivity$1", "moduleAdded"));
                }
                instance.queueUpdate();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                GrailsConfigUtils.checkGrailsShellConfigured(project);
                instance.queueUpdate();
            }
        });
        connection.subscribe(GrailsSettingsListener.LISTENER_TOPIC, (Object)new GrailsSettingsListener.Adapter(){

            @Override
            public void onSDKHomeChange() {
                GrailsConfigUtils.checkGrailsShellConfigured(project);
                MvcModuleStructureSynchronizer.getInstance((Project)project).queue(MvcModuleStructureSynchronizer.SyncAction.EnsureRunConfigurationExists, (Object)project);
                instance.queueUpdate();
            }
        });
    }
}

