/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;

public class GrailsSpringFacetProvider
implements GrailsFacetProvider {
    @NonNls
    private static final String GRAILS_FILESET = "Grails";
    private static final String[] configurationLocations = new String[]{"web-app/WEB-INF/applicationContext.xml", "grails-app/conf/spring/resources.xml"};

    @Override
    public void addFacets(Collection<Runnable> actions, final FacetManager facetManager, final Module module, Collection<VirtualFile> roots) {
        final ArrayList<VirtualFile> configFiles = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            for (String configurationLocation : configurationLocations) {
                VirtualFile appContext = root.findFileByRelativePath(configurationLocation);
                if (appContext == null) continue;
                configFiles.add(appContext);
            }
        }
        Collection facets = facetManager.getFacetsByType(SpringFacet.FACET_TYPE_ID);
        if (facets.isEmpty()) {
            actions.add(new Runnable(){

                @Override
                public void run() {
                    SpringFacet facet = (SpringFacet)SpringFacet.getSpringFacetType().createFacet(module, "Spring", SpringFacet.getSpringFacetType().createDefaultConfiguration(), null);
                    if (!configFiles.isEmpty()) {
                        SpringFileSet fileSet = facet.addFileSet(GrailsSpringFacetProvider.GRAILS_FILESET, GrailsSpringFacetProvider.GRAILS_FILESET);
                        for (VirtualFile configFile : configFiles) {
                            fileSet.addFile(configFile);
                        }
                    }
                    ModifiableFacetModel model = facetManager.createModifiableModel();
                    model.addFacet((Facet)facet);
                    model.commit();
                }
            });
        } else if (!configFiles.isEmpty()) {
            SpringFileSet fileSet = null;
            for (SpringFacet springFacet : facets) {
                for (SpringFileSet set : springFacet.getFileSets()) {
                    if (GRAILS_FILESET.equals(set.getId())) {
                        fileSet = set;
                    }
                    Iterator itr = configFiles.iterator();
                    while (itr.hasNext()) {
                        VirtualFile file = (VirtualFile)itr.next();
                        if (!set.hasFile(file)) continue;
                        itr.remove();
                    }
                }
            }
            if (fileSet != null && configFiles.size() > 0) {
                final SpringFileSet finalFileSet = fileSet;
                actions.add(new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile configFile : configFiles) {
                            finalFileSet.addFile(configFile);
                        }
                    }
                });
            }
        }
    }
}

