/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import icons.GroovyMvcIcons;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.util.GrailsArtifactCache;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public class GrailsArtifact
extends Enum<GrailsArtifact> {
    public static final /* enum */ GrailsArtifact DOMAIN = new GrailsArtifact(JetgroovyIcons.Mvc.Domain_class, "", "domain");
    public static final /* enum */ GrailsArtifact CONTROLLER = new GrailsArtifact(JetgroovyIcons.Mvc.Controller, "Controller", "controllers");
    public static final /* enum */ GrailsArtifact TAGLIB = new GrailsArtifact(GroovyMvcIcons.Taglib, "TagLib", "taglib");
    public static final /* enum */ GrailsArtifact SERVICE = new GrailsArtifact(JetgroovyIcons.Mvc.Service, "Service", "services");
    public static final /* enum */ GrailsArtifact JOB = new GrailsArtifact(null, "Job", "jobs");
    public static final /* enum */ GrailsArtifact CODEC = new GrailsArtifact(null, "Codec", "utils");
    public static final /* enum */ GrailsArtifact FILTER = new GrailsArtifact(null, "Filters", "conf");
    public static final /* enum */ GrailsArtifact REALM = new GrailsArtifact(null, "Realm", "realms");
    public static final /* enum */ GrailsArtifact URLMAPPINGS = new GrailsArtifact(null, "UrlMappings", "conf", true){

        @Override
        public String getDirectory(Module module) {
            return GrailsStructure.isVersionAtLeast("3.0", module) ? "controllers" : "conf";
        }
    };
    public static final /* enum */ GrailsArtifact BOOTSTRAP = new GrailsArtifact(null, "BootStrap", "conf", true){

        @Override
        public String getDirectory(Module module) {
            return GrailsStructure.isVersionAtLeast("3.0", module) ? "init" : "conf";
        }
    };
    public static final /* enum */ GrailsArtifact RESOURCES = new GrailsArtifact(null, "Resources", "conf", true);
    public static final /* enum */ GrailsArtifact RESOURCE_MAPPER = new GrailsArtifact(null, "ResourceMapper", "resourceMappers");
    public static final /* enum */ GrailsArtifact INTERCEPTOR = new GrailsArtifact(AllIcons.General.Filter, "Interceptor", "controllers", false);
    @Nullable
    private final Icon myIcon;
    public final String suffix;
    public final String fileSuffix;
    private final String myDirectoryName;
    public final boolean mayHaveEmptyName;
    private final Key<CachedValue<GrailsArtifactCache>> cacheKey;
    private static final /* synthetic */ GrailsArtifact[] $VALUES;

    public static GrailsArtifact[] values() {
        return (GrailsArtifact[])$VALUES.clone();
    }

    public static GrailsArtifact valueOf(String name) {
        return Enum.valueOf(GrailsArtifact.class, name);
    }

    private GrailsArtifact(Icon icon, String suffix, String dir) {
        this(icon, suffix, dir, false);
    }

    private GrailsArtifact(Icon icon, String suffix, String dir, boolean mayHaveEmptyName) {
        this.myIcon = icon;
        this.suffix = suffix;
        this.fileSuffix = suffix + ".groovy";
        this.myDirectoryName = dir;
        this.cacheKey = Key.create((String)("GrailArtifact " + dir));
        this.mayHaveEmptyName = mayHaveEmptyName;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public String getDirectory(Module module) {
        return this.myDirectoryName;
    }

    @Nullable
    private static VirtualFile getSourceRoot(@NotNull VirtualFile file, Project project) {
        VirtualFile p;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getSourceRoot"));
        }
        if (file.isDirectory()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot != null) {
            VirtualFile parent = sourceRoot.getParent();
            if (parent == null || !parent.getName().equals("grails-app")) {
                return null;
            }
            return sourceRoot;
        }
        VirtualFile root = fileIndex.getContentRootForFile(file);
        if (root == null) {
            return null;
        }
        VirtualFile f = file;
        VirtualFile parent = f.getParent();
        if (parent == null) {
            return null;
        }
        while (!Comparing.equal((Object)(p = parent.getParent()), (Object)root) && p != null) {
            f = parent;
            parent = p;
        }
        if (parent.getName().equals("grails-app")) {
            return f;
        }
        return null;
    }

    private boolean endWithSuffix(String name) {
        return name.endsWith(this.suffix) && (this.mayHaveEmptyName || name.length() > this.suffix.length());
    }

    private boolean endWithFileSuffix(String name) {
        return name.endsWith(this.fileSuffix) && (this.mayHaveEmptyName || name.length() > this.fileSuffix.length());
    }

    public boolean isInstance(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/util/GrailsArtifact", "isInstance"));
        }
        return this.getGrailsApp(virtualFile, project) != null;
    }

    @Nullable
    private VirtualFile getGrailsApp(@Nullable VirtualFile file, Project project) {
        if (file == null) {
            return null;
        }
        if (!this.endWithFileSuffix(file.getName())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        VirtualFile sourceRoot = GrailsArtifact.getSourceRoot(file, project);
        if (sourceRoot == null) {
            return null;
        }
        if (!sourceRoot.getName().equals(this.getDirectory(module))) {
            return null;
        }
        return sourceRoot.getParent();
    }

    private boolean isNameEndWithSuffix(PsiClass psiClass) {
        String className = psiClass.getName();
        return className != null && this.endWithSuffix(className);
    }

    @Nullable
    public VirtualFile getGrailsApp(@Nullable PsiClass psiClass) {
        if (!(psiClass instanceof GrClassDefinition)) {
            return null;
        }
        if (!this.isNameEndWithSuffix(psiClass) || PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class) != null) {
            return null;
        }
        return this.getGrailsApp(psiClass.getContainingFile().getOriginalFile().getVirtualFile(), psiClass.getProject());
    }

    @Nullable
    public static GrailsArtifact getType(@Nullable PsiClass psiClass) {
        if (!(psiClass instanceof GrClassDefinition)) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        VirtualFile sourceRoot = GrailsArtifact.getSourceRoot(virtualFile, psiFile.getProject());
        if (sourceRoot == null) {
            return null;
        }
        GrailsArtifact[] artifacts = GrailsArtifact.getSourceRootMap(module).get(sourceRoot.getName());
        if (artifacts == null) {
            return null;
        }
        String className = psiClass.getName();
        if (className == null) {
            return null;
        }
        for (GrailsArtifact candidate : artifacts) {
            if (!candidate.endWithSuffix(className)) continue;
            return candidate;
        }
        return null;
    }

    public boolean isInstance(@Nullable PsiClass psiClass) {
        return this.getGrailsApp(psiClass) != null;
    }

    @NotNull
    public String getArtifactName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getArtifactName"));
        }
        String string = this.getArtifactName(psiClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getArtifactName"));
        }
        return string;
    }

    @NotNull
    public String getArtifactNameByFileName(String fileName) {
        assert (this.endWithFileSuffix(fileName));
        String string = StringUtil.decapitalize((String)fileName.substring(0, fileName.length() - this.fileSuffix.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getArtifactNameByFileName"));
        }
        return string;
    }

    @NotNull
    public String getArtifactName(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getArtifactName"));
        }
        assert (this.endWithSuffix(className));
        String string = StringUtil.decapitalize((String)className.substring(0, className.length() - this.suffix.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getArtifactName"));
        }
        return string;
    }

    @Nullable
    public VirtualFile findDirectory(@Nullable Module module) {
        VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(module);
        if (appDir == null) {
            return null;
        }
        return appDir.findChild(this.getDirectory(module));
    }

    public MultiMap<String, VirtualFile> getVirtualFileMap(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getVirtualFileMap"));
        }
        return this.getCache(module).getVirtualFileMap();
    }

    @NotNull
    public Collection<GrClassDefinition> getInstances(@NotNull Module module, @Nullable String name) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getInstances"));
        }
        if (name == null) {
            List<GrClassDefinition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getInstances"));
            }
            return list;
        }
        List<GrClassDefinition> list = this.getCache(module).getClasses(name);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getInstances"));
        }
        return list;
    }

    private GrailsArtifactCache getCache(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getCache"));
        }
        final Project project = module.getProject();
        return (GrailsArtifactCache)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, this.cacheKey, (CachedValueProvider)new CachedValueProvider<GrailsArtifactCache>(){

            public CachedValueProvider.Result<GrailsArtifactCache> compute() {
                MultiMap map = GrailsArtifact.this.calculateInstances(module);
                MvcModuleStructureSynchronizer synchronizer = MvcModuleStructureSynchronizer.getInstance((Project)project);
                return CachedValueProvider.Result.create((Object)new GrailsArtifactCache((MultiMap<String, VirtualFile>)map, project), (Object[])new Object[]{synchronizer.getFileAndRootsModificationTracker()});
            }
        }, false);
    }

    @NotNull
    public MultiMap<String, GrClassDefinition> getInstances(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getInstances"));
        }
        MultiMap<String, GrClassDefinition> multiMap = this.getCache(module).getClassesMap();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getInstances"));
        }
        return multiMap;
    }

    private void calculateInstancesInDirectory(@NotNull VirtualFile contentEntry, final MultiMap<String, VirtualFile> map, ProjectFileIndex fileIndex) {
        if (contentEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentEntry", "org/jetbrains/plugins/grails/util/GrailsArtifact", "calculateInstancesInDirectory"));
        }
        fileIndex.iterateContentUnderDirectory(contentEntry, new ContentIterator(){

            public final boolean processFile(VirtualFile fileOrDir) {
                String name;
                if (!fileOrDir.isDirectory() && GrailsArtifact.this.endWithFileSuffix(name = fileOrDir.getName())) {
                    map.putValue((Object)GrailsArtifact.this.getArtifactNameByFileName(name), (Object)fileOrDir);
                }
                return true;
            }
        });
    }

    @NotNull
    private MultiMap<String, VirtualFile> calculateInstances(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/util/GrailsArtifact", "calculateInstances"));
        }
        MultiMap res = MultiMap.createSmart();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        HashSet modules = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, modules);
        for (Module m : modules) {
            if (GrailsFramework.getInstance().isCommonPluginsModule(m)) {
                for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)m).getContentRoots()) {
                    VirtualFile dir;
                    VirtualFile appDirectory = virtualFile.findChild("grails-app");
                    if (appDirectory == null || (dir = appDirectory.findChild(this.getDirectory(m))) == null) continue;
                    this.calculateInstancesInDirectory(dir, (MultiMap<String, VirtualFile>)res, fileIndex);
                }
                continue;
            }
            VirtualFile directory = this.findDirectory(m);
            if (directory == null) continue;
            this.calculateInstancesInDirectory(directory, (MultiMap<String, VirtualFile>)res, fileIndex);
        }
        MultiMap multiMap = res;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "calculateInstances"));
        }
        return multiMap;
    }

    @NotNull
    private static Map<String, GrailsArtifact[]> getSourceRootMap(final @Nullable Module module) {
        if (module == null) {
            Map<String, GrailsArtifact[]> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getSourceRootMap"));
            }
            return map;
        }
        final Project project = module.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Map<String, GrailsArtifact[]>>(){

            @Nullable
            public CachedValueProvider.Result<Map<String, GrailsArtifact[]>> compute() {
                MultiMap multiMap = new MultiMap();
                for (GrailsArtifact artifact : GrailsArtifact.values()) {
                    multiMap.putValue((Object)artifact.getDirectory(module), (Object)artifact);
                }
                HashMap result = new HashMap();
                for (Map.Entry entry : multiMap.entrySet()) {
                    Collection artifacts = (Collection)entry.getValue();
                    result.put(entry.getKey(), artifacts.toArray(new GrailsArtifact[artifacts.size()]));
                }
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{MvcModuleStructureSynchronizer.getInstance((Project)project).getFileAndRootsModificationTracker()});
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/util/GrailsArtifact", "getSourceRootMap"));
        }
        return map;
    }

    static {
        $VALUES = new GrailsArtifact[]{DOMAIN, CONTROLLER, TAGLIB, SERVICE, JOB, CODEC, FILTER, REALM, URLMAPPINGS, BOOTSTRAP, RESOURCES, RESOURCE_MAPPER, INTERCEPTOR};
    }
}

