/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;

public class GrailsWebFacetProvider
implements GrailsFacetProvider {
    private static final String GRAILS_WEB_FACET = "GrailsWeb";

    @Override
    public void addFacets(Collection<Runnable> actions, final FacetManager facetManager, final Module module, Collection<VirtualFile> roots) {
        if (GrailsStructure.isVersionAtLeast("3.0", module) || ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) && module.getOptionValue("grails.gradle.pluginId") != "grails") {
            return;
        }
        final ArrayList webRoots = new ArrayList();
        for (VirtualFile root : roots) {
            ContainerUtil.addIfNotNull((Object)root.findChild("web-app"), webRoots);
            ContainerUtil.addIfNotNull((Object)VfsUtil.findRelativeFile((VirtualFile)root, (String[])new String[]{"grails-app", "views"}), webRoots);
        }
        WebFacet grailsFacet = null;
        Collection facets = facetManager.getFacetsByType(WebFacet.ID);
        for (Object facet : facets) {
            if (GRAILS_WEB_FACET.equals(facet.getName())) {
                grailsFacet = facet;
                continue;
            }
            for (WebRoot webRoot : facet.getWebRoots()) {
                webRoots.remove(webRoot.getFile());
            }
        }
        if (grailsFacet == null) {
            if (webRoots.size() > 0) {
                actions.add(new Runnable(){

                    @Override
                    public void run() {
                        WebFacetConfiguration configuration = WebFacetType.getInstance().createDefaultConfiguration();
                        WebFacet grailsFacet = WebFacetType.getInstance().createFacet(module, GrailsWebFacetProvider.GRAILS_WEB_FACET, configuration, null);
                        for (VirtualFile virtualFile : webRoots) {
                            grailsFacet.addWebRoot(virtualFile, "/");
                        }
                        ModifiableFacetModel model = facetManager.createModifiableModel();
                        model.addFacet((Facet)grailsFacet);
                        model.commit();
                    }
                });
            }
            return;
        }
        final ArrayList<WebRoot> toRemove = new ArrayList<WebRoot>();
        for (WebRoot webRoot : grailsFacet.getWebRoots()) {
            VirtualFile file = webRoot.getFile();
            if (webRoots.remove(file) || file != null && GrailsWebFacetProvider.isInProject(file, grailsFacet.getModule().getProject())) continue;
            toRemove.add(webRoot);
        }
        if (toRemove.size() > 0 || webRoots.size() > 0) {
            final WebFacet finalGrailsFacet = grailsFacet;
            actions.add(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile virtualFile : webRoots) {
                        finalGrailsFacet.addWebRoot(virtualFile, "/");
                    }
                    for (WebRoot webRoot : toRemove) {
                        finalGrailsFacet.removeWebRoot(webRoot);
                    }
                }
            });
        }
    }

    public static boolean isInProject(VirtualFile file, Project project) {
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file);
    }
}

