/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class Grails3InstallationCommandExecutor
extends GrailsCommandExecutor {
    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "isApplicable"));
        }
        return StringUtil.isNotEmpty((String)PropertiesComponent.getInstance((Project)module.getProject()).getValue("grails.sdk.home"));
    }

    @Override
    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "createJavaParameters"));
        }
        return Grails3InstallationCommandExecutor.createJavaParametersInner(module, command);
    }

    @Override
    public JavaParameters createJavaParametersForRun(@NotNull Module module, boolean classpathFromDependencies, @Nullable Object additionalConfiguration, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "createJavaParametersForRun"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "createJavaParametersForRun"));
        }
        return Grails3InstallationCommandExecutor.createJavaParametersInner(module, command);
    }

    public static JavaParameters createJavaParametersInner(@NotNull Module module, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "createJavaParametersInner"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/Grails3InstallationCommandExecutor", "createJavaParametersInner"));
        }
        JavaParameters params = new JavaParameters();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            throw new ExecutionException("JDK is not defined");
        }
        String grailsSDKHomePath = PropertiesComponent.getInstance((Project)module.getProject()).getValue("grails.sdk.home");
        if (grailsSDKHomePath == null) {
            throw new ExecutionException("Grails SDK is not defined");
        }
        File grailsSDKHome = new File(grailsSDKHomePath);
        if (!grailsSDKHome.exists() || !grailsSDKHome.isDirectory()) {
            throw new ExecutionException("Grails SDK not found in '" + grailsSDKHomePath + "'");
        }
        params.setJdk(sdk);
        params.setDefaultCharset(module.getProject());
        params.getVMParametersList().addAll(new String[]{"-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1", "-XX:CICompilerCount=3"});
        params.getVMParametersList().addParametersString(command.getVmOptions());
        Grails3InstallationCommandExecutor.addCommonJvmOptions(params);
        params.getClassPath().addAllFiles(Grails3InstallationCommandExecutor.runClassPath(grailsSDKHome));
        params.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
        params.setMainClass("org.grails.cli.GrailsCli");
        command.addToParametersList(params.getProgramParametersList());
        return params;
    }

    private static List<File> runClassPath(File grailsSDKHome) {
        File grailsSDKDist = new File(grailsSDKHome.getAbsolutePath() + "/dist");
        File grailsSDKLib = new File(grailsSDKHome.getAbsolutePath() + "/lib");
        if (!grailsSDKDist.exists() || !grailsSDKLib.exists()) {
            return Collections.emptyList();
        }
        final ArrayList result = ContainerUtil.newArrayList();
        FileUtil.processFilesRecursively((File)grailsSDKHome, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".jar") && !fileName.endsWith("-sources.jar") && !fileName.endsWith("-javadoc.jar") && !fileName.matches("javaee-(web-)?api(-\\d(\\.\\d)*)?.jar")) {
                    result.add(file);
                }
                return true;
            }
        });
        return result;
    }
}

