/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.grails.GrailsCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsInstallationCommandExecutor
extends GrailsCommandExecutor {
    @Override
    public boolean isApplicable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "isApplicable"));
        }
        return GrailsConfigUtils.getSDKInstallPath(module) != null && GrailsConfigUtils.isGrailsLessThan(module, "3.0.0");
    }

    @Override
    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        return GrailsInstallationCommandExecutor.createJavaParameters(module, forCreation, false, command);
    }

    @Override
    public JavaParameters createJavaParametersForRun(@NotNull Module module, boolean classpathFromDependencies, @Nullable Object additionalConfiguration, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "createJavaParametersForRun"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "createJavaParametersForRun"));
        }
        return GrailsInstallationCommandExecutor.createJavaParameters(module, false, classpathFromDependencies, command);
    }

    @Override
    public void addListener(JavaParameters params, String listener) {
        super.addListener(params, listener);
        String listenerJar = PathUtil.getJarPathForClass(GrailsRtMarker.class);
        List programParams = params.getProgramParametersList().getList();
        int cpIndex = programParams.indexOf("--classpath");
        if (cpIndex != -1 && cpIndex < programParams.size() - 1) {
            PathsList pathsList = new PathsList();
            pathsList.add((String)programParams.get(cpIndex + 1));
            pathsList.add(listenerJar);
            params.getProgramParametersList().replaceOrAppend((String)programParams.get(cpIndex + 1), pathsList.getPathsString());
        } else {
            params.getProgramParametersList().addAt(0, "--classpath");
            params.getProgramParametersList().addAt(1, listenerJar);
        }
    }

    private static JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, boolean classpathFromDependencies, @NotNull MvcCommand command) throws ExecutionException {
        String grailsOpts;
        String pathStr;
        VirtualFile rootFile;
        File[] files;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "createJavaParameters"));
        }
        JavaParameters params = new JavaParameters();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            throw new ExecutionException("JDK is not defined");
        }
        params.setJdk(sdk);
        VirtualFile sdkInstallPath = GrailsFramework.getInstance().getSdkRoot(module);
        assert (sdkInstallPath != null);
        String grailsHome = PathUtil.getLocalPath((VirtualFile)sdkInstallPath);
        params.addEnv(GrailsFramework.getInstance().getSdkHomePropertyName(), FileUtil.toSystemDependentName((String)sdkInstallPath.getPath()));
        File groovyJar = null;
        String version = GrailsConfigUtils.getGrailsVersion(module);
        if (version == null) {
            version = "zzz";
        }
        if (version.compareTo("1.4") >= 0) {
            groovyJar = GrailsUtils.findLatestJarInIvyRepository(grailsHome + "/lib/org.codehaus.groovy/groovy-all", "groovy-all-");
        } else {
            files = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsHome + "/lib"), (String)"groovy-all-\\d[^-]*\\.jar");
            if (files.length > 0) {
                groovyJar = files[0];
            }
        }
        if (groovyJar != null) {
            params.getClassPath().add(groovyJar.getAbsolutePath());
        }
        if ((files = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsHome + "/dist/"), (String)"grails-cli-\\d[^-]*(?:-SNAPSHOT)?\\.jar")).length > 0) {
            params.getClassPath().add(files[0].getAbsolutePath());
        }
        if ((files = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsHome + "/dist/"), (String)"grails-bootstrap-\\d[^-]*(?:-SNAPSHOT)?\\.jar")).length > 0) {
            params.getClassPath().add(files[0].getAbsolutePath());
        }
        params.setMainClass("org.codehaus.groovy.grails.cli.support.GrailsStarter");
        if (forCreation) {
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length != 1) {
                throw new ExecutionException("Failed to initialize grails module: module " + module.getName() + " contains more than one root");
            }
            command.setArgs(Collections.singletonList(roots[0].getName()));
            rootFile = roots[0].getParent();
        } else {
            rootFile = GrailsUtils.findGrailsAppRoot(module);
            if (rootFile == null) {
                throw new ExecutionException("Failed to run grails command: module " + module.getName() + " is not a grails module");
            }
        }
        String workDir = VfsUtil.virtualToIoFile((VirtualFile)rootFile).getAbsolutePath();
        params.getVMParametersList().add("-Dgrails.home=" + grailsHome);
        params.getVMParametersList().add("-Dbase.dir=" + workDir);
        SdkTypeId sdkType = sdk.getSdkType();
        if (sdkType instanceof JavaSdkType) {
            params.getVMParametersList().add("-Dtools.jar=" + ((JavaSdkType)sdkType).getToolsPath(sdk));
        }
        String confpath = grailsHome + "/conf/groovy-starter.conf";
        params.getVMParametersList().add("-Dgroovy.starter.conf=" + confpath);
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add("org.codehaus.groovy.grails.cli.GrailsScriptRunner");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confpath);
        PathsList cp = new PathsList();
        if (classpathFromDependencies) {
            cp.addVirtualFiles((Collection)GrailsFramework.getInstance().getApplicationClassPath(module).getVirtualFiles());
        }
        if (version.compareTo("1.1") < 0) {
            cp.add(".");
        }
        if ((pathStr = cp.getPathsString()).length() > 0) {
            params.getProgramParametersList().add("--classpath");
            params.getProgramParametersList().add(pathStr);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(grailsOpts = System.getenv("GRAILS_OPTS")))) {
            params.getVMParametersList().addParametersString(grailsOpts);
        }
        params.getVMParametersList().addParametersString(command.getVmOptions());
        String parametersString = params.getVMParametersList().getParametersString();
        if (!JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_8)) {
            if (version.compareTo("2.0") >= 0) {
                if (GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xmx", "768M")) {
                    GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xms", "768M");
                }
                if (GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:MaxPermSize=", "256m")) {
                    GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:PermSize=", "256m");
                }
            } else {
                GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xmx", "512M");
                GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:MaxPermSize=", "192m");
            }
        }
        GrailsInstallationCommandExecutor.addCommonJvmOptions(params);
        params.setWorkingDirectory(workDir);
        ParametersList paramList = new ParametersList();
        command.addToParametersList(paramList);
        if (!paramList.hasParameter("-plain-output") && GrailsConfigUtils.isAtLeastGrails2_0(module)) {
            paramList.add("-plain-output");
        }
        params.getProgramParametersList().add(paramList.getParametersString());
        params.setDefaultCharset(module.getProject());
        File springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsHome + "/lib/org.springframework/springloaded", "springloaded-");
        if (springLoadedJar == null && (springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsHome + "/lib/org.springsource.springloaded/springloaded-core", "springloaded-core-")) == null) {
            springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsHome + "/lib/com.springsource.springloaded/springloaded-core", "springloaded-core-");
        }
        if (springLoadedJar != null && GrailsInstallationCommandExecutor.enableReloader(command)) {
            params.getVMParametersList().add("-javaagent:" + springLoadedJar.getAbsolutePath());
            params.getVMParametersList().add("-noverify");
            if (!params.getVMParametersList().hasProperty("springloaded")) {
                params.getVMParametersList().addProperty("springloaded", "profile=grails;cacheDir=.");
            }
        }
        return params;
    }

    private static boolean addMemoryConstraintIfNotExists(String existedParams, JavaParameters javaParameters, String paramName, String value) {
        if (!existedParams.contains(paramName)) {
            javaParameters.getVMParametersList().add(paramName + value);
            return true;
        }
        return false;
    }

    private static boolean enableReloader(@NotNull MvcCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/groovy/grails/GrailsInstallationCommandExecutor", "enableReloader"));
        }
        ArrayList args = command.getArgs();
        return args.contains("-reloading") || "run-app".equals(command.getCommand()) && !args.contains("-noreloading");
    }
}

