/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.references.constraints.GrailsConstraintsUtil;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsDomainAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/groovy/grails/annotator/GrailsDomainAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/grails/annotator/GrailsDomainAnnotator", "annotate"));
        }
        if (!(psiElement instanceof GroovyFile)) {
            return;
        }
        for (GrTypeDefinition grTypeDefinition : ((GroovyFile)psiElement).getTypeDefinitions()) {
            if (!GormUtils.isGormBean((PsiClass)grTypeDefinition)) continue;
            GrailsDomainAnnotator.checkBelongsToAndHasManyRelations((PsiClass)grTypeDefinition, holder);
            GrailsDomainAnnotator.checkMappedBy((PsiClass)grTypeDefinition, holder);
            GrailsDomainAnnotator.checkConstraints(grTypeDefinition, holder);
        }
    }

    private static void checkConstraints(GrTypeDefinition domainClass, AnnotationHolder holder) {
        GrField constraintsField = (GrField)domainClass.findFieldByName("constraints", false);
        if (constraintsField == null) {
            return;
        }
        GrExpression initializerGroovy = constraintsField.getInitializerGroovy();
        if (!(initializerGroovy instanceof GrClosableBlock)) {
            return;
        }
        final Map<String, Pair<PsiType, PsiElement>> fields = DomainDescriptor.getDescriptor((PsiClass)domainClass).getPersistentProperties();
        HashMap constraints = new HashMap();
        initializerGroovy.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor((Map)constraints, holder){
            final /* synthetic */ Map val$constraints;
            final /* synthetic */ AnnotationHolder val$holder;
            {
                this.val$constraints = map2;
                this.val$holder = annotationHolder;
            }

            public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
                PsiMethod method = methodCallExpression.resolveMethod();
                if (GrailsConstraintsUtil.isConstraintsMethod((PsiElement)method)) {
                    assert (method != null);
                    String fieldName = method.getName();
                    if (fields.containsKey(fieldName)) {
                        Map fieldConstraints = (Map)this.val$constraints.get(fieldName);
                        if (fieldConstraints == null) {
                            fieldConstraints = new HashMap();
                            this.val$constraints.put(fieldName, fieldConstraints);
                        }
                        for (GrNamedArgument argument : PsiUtil.getFirstMapNamedArguments((GrCall)methodCallExpression)) {
                            String constraintType = argument.getLabelName();
                            GrNamedArgument oldConstraint = fieldConstraints.put(constraintType, argument);
                            if (oldConstraint == null) continue;
                            GrArgumentLabel oldArgumentLabel = oldConstraint.getLabel();
                            assert (oldArgumentLabel != null);
                            this.val$holder.createWarningAnnotation((PsiElement)oldArgumentLabel, "Constraint '" + constraintType + "' already defined for field '" + fieldName + '\'');
                        }
                    }
                }
                super.visitMethodCallExpression(methodCallExpression);
            }
        });
    }

    private static void checkBelongsToAndHasManyRelations(PsiClass domainClass, AnnotationHolder holder) {
        PsiField hasMany;
        Map<String, Pair<PsiType, PsiElement>> fields = DomainDescriptor.getDescriptor(domainClass).getPersistentProperties();
        PsiField belongs = domainClass.findFieldByName("belongsTo", false);
        GrListOrMap lom = GrailsDomainAnnotator.getListOrMap(belongs);
        if (lom != null) {
            if (lom.isMap()) {
                for (GrNamedArgument argument : lom.getNamedArguments()) {
                    GrailsDomainAnnotator.checkNamedArgumentForBelongsTo(argument, fields, holder);
                }
            }
            GrailsDomainAnnotator.processDuplicates(holder, lom);
        }
        if ((lom = GrailsDomainAnnotator.getListOrMap(hasMany = domainClass.findFieldByName("hasMany", false))) != null) {
            if (!lom.isMap()) {
                holder.createWarningAnnotation((PsiElement)lom, GrailsBundle.message("must.contain.map", new Object[0]));
            }
            GrailsDomainAnnotator.processDuplicates(holder, lom);
        }
    }

    private static void checkMappedBy(PsiClass domainClass, AnnotationHolder holder) {
        PsiField mappedBy = domainClass.findFieldByName("mappedBy", false);
        if (mappedBy == null || !mappedBy.hasModifierProperty("static")) {
            return;
        }
        PsiField hasMany = domainClass.findFieldByName("hasMany", false);
        if (hasMany == null || !hasMany.hasModifierProperty("static")) {
            holder.createWarningAnnotation((PsiElement)mappedBy.getNameIdentifier(), GrailsBundle.message("mapped.by.is.used.without.has.many", new Object[0]));
            return;
        }
        GrListOrMap lom = GrailsDomainAnnotator.getListOrMap(mappedBy);
        if (lom != null) {
            if (lom.isMap()) {
                HashSet names = new HashSet();
                Map<String, Pair<PsiType, PsiElement>> hasManyMap = DomainDescriptor.getDescriptor(domainClass).getHasMany();
                for (GrNamedArgument argument : lom.getNamedArguments()) {
                    PsiReference ref;
                    GrArgumentLabel label = argument.getLabel();
                    if (label == null) continue;
                    String name = label.getName();
                    if (names.contains(name)) {
                        holder.createWarningAnnotation((PsiElement)label, GrailsBundle.message("duplicate.property.name", new Object[0]));
                        continue;
                    }
                    names.add(name);
                    Pair<PsiType, PsiElement> pair = hasManyMap.get(name);
                    if (pair == null) {
                        holder.createWarningAnnotation((PsiElement)label, GrailsBundle.message("property.is.absent.in.has.many", name));
                        continue;
                    }
                    GrExpression expression = argument.getExpression();
                    if (!(expression instanceof GrLiteral) || !(((GrLiteral)expression).getValue() instanceof String) || (ref = expression.getReference()) == null) continue;
                    Object value = ((GrLiteral)expression).getValue();
                    PsiElement resolved = ref.resolve();
                    if (resolved == null) {
                        holder.createWarningAnnotation((PsiElement)expression, GrailsBundle.message("property.is.absent", ((PsiType)pair.first).getPresentableText(), value));
                        continue;
                    }
                    PsiType propertyType = DomainClassUtils.getDCPropertyType(resolved);
                    if (propertyType instanceof PsiClassType) {
                        PsiClass resolvedClass = ((PsiClassType)propertyType).resolve();
                        if (domainClass.getManager().areElementsEquivalent((PsiElement)domainClass, (PsiElement)resolvedClass)) continue;
                        holder.createWarningAnnotation((PsiElement)expression, GrailsBundle.message("property.has.wrong.type", value, propertyType.getPresentableText()));
                        continue;
                    }
                    holder.createWarningAnnotation((PsiElement)expression, GrailsBundle.message("property.has.wrong.type", value, propertyType != null ? propertyType.getPresentableText() : "null"));
                }
            } else {
                holder.createWarningAnnotation((PsiElement)lom, GrailsBundle.message("must.contain.map", new Object[0]));
            }
        }
    }

    private static void checkNamedArgumentForBelongsTo(GrNamedArgument argument, Map<String, Pair<PsiType, PsiElement>> fields, AnnotationHolder holder) {
        GrArgumentLabel label = argument.getLabel();
        if (label != null) {
            PsiClass fieldClass;
            PsiElement element;
            GrExpression expression = argument.getExpression();
            PsiClass labelClass = null;
            if (expression instanceof GrReferenceExpression && (element = ((GrReferenceExpression)expression).resolve()) instanceof PsiClass) {
                labelClass = (PsiClass)element;
            }
            if (labelClass == null) {
                return;
            }
            if (!GormUtils.isGormBean(labelClass)) {
                holder.createWarningAnnotation((PsiElement)expression, GrailsBundle.message("must.be.domain.class.name", new Object[0]));
                return;
            }
            String name = label.getName();
            Pair<PsiType, PsiElement> pair = fields.get(name);
            if (pair != null && (fieldClass = PsiTypesUtil.getPsiClass((PsiType)((PsiType)pair.first))) != null && !fieldClass.getManager().areElementsEquivalent((PsiElement)fieldClass, (PsiElement)labelClass) && !labelClass.isInheritor(fieldClass, true)) {
                holder.createWarningAnnotation((PsiElement)argument, GrailsBundle.message("property.is.abmbigous", name, fieldClass.getQualifiedName()));
            }
        }
    }

    @Nullable
    private static GrListOrMap getListOrMap(@Nullable PsiField field) {
        GrExpression initializer;
        if (field instanceof GrField && (initializer = ((GrField)field).getInitializerGroovy()) instanceof GrListOrMap) {
            return (GrListOrMap)initializer;
        }
        return null;
    }

    private static void processDuplicates(AnnotationHolder holder, GrListOrMap lom) {
        if (lom.isMap()) {
            HashSet names = new HashSet();
            for (GrNamedArgument argument : lom.getNamedArguments()) {
                String name;
                GrArgumentLabel label = argument.getLabel();
                if (label == null || (name = label.getName()) == null || names.add(name)) continue;
                holder.createWarningAnnotation((PsiElement)label, GrailsBundle.message("duplicate.property.name", new Object[0]));
            }
        } else {
            HashSet classNames = new HashSet();
            for (GrExpression expr : lom.getInitializers()) {
                if (!(expr instanceof GrReferenceExpression)) continue;
                PsiElement element = ((GrReferenceExpression)expr).resolve();
                if (element instanceof PsiClass) {
                    String qname = ((PsiClass)element).getQualifiedName();
                    assert (qname != null);
                    if (classNames.add(qname)) continue;
                    holder.createWarningAnnotation((PsiElement)expr, GrailsBundle.message("duplicate.type", "list"));
                    continue;
                }
                holder.createWarningAnnotation((PsiElement)expr, "Class name expected");
            }
        }
    }
}

