/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.config.GrailsStructure;

public class GrailsForkSettingsNotificator
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"grails.fork.settings");
    private final Project myProject;

    public GrailsForkSettingsNotificator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsForkSettingsNotificator", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsForkSettingsNotificator", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        Module module;
        GrailsStructure structure;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/grails/annotator/GrailsForkSettingsNotificator", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "org/jetbrains/plugins/groovy/grails/annotator/GrailsForkSettingsNotificator", "createNotificationPanel"));
        }
        if (file.getName().equals("BuildConfig.groovy") && (structure = GrailsStructure.getInstance(module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject))) != null) {
            if ((GrailsSettingsService.isDebugRunForked(module) || GrailsSettingsService.isDebugTestForked(module)) && !structure.isAtLeastGrails("2.3.5")) {
                return GrailsForkSettingsNotificator.createNotification(GrailsBundle.message("fork.mode.warning.2.3.5", structure.getGrailsVersion()));
            }
            if (GrailsSettingsService.isDebugTestForked(module) && !structure.isAtLeastGrails("2.3.10")) {
                return GrailsForkSettingsNotificator.createNotification(GrailsBundle.message("fork.mode.warning.2.3.10", structure.getGrailsVersion()));
            }
        }
        return null;
    }

    private static EditorNotificationPanel createNotification(String message) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(message);
        return panel;
    }
}

