/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettingSynchronizer;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GrailsSynchronizeStructureAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        VirtualFile file;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator", "annotate"));
        }
        if (element instanceof GroovyFile && (file = ((GroovyFile)element).getVirtualFile()) != null && file.getName().equals("BuildConfig.groovy")) {
            VirtualFile confDir = file.getParent();
            if (confDir == null || !confDir.getName().equals("conf")) {
                return;
            }
            VirtualFile grailsApp = confDir.getParent();
            if (grailsApp == null || !grailsApp.getName().equals("grails-app")) {
                return;
            }
            if (GrailsSettingSynchronizer.isUpdateSettingRunning()) {
                return;
            }
            final Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module != null && GrailsUtils.hasSupport(module) && GrailsSettingsService.getGrailsSettings(module).isBuildConfigOutdated(element.getText())) {
                Annotation annotation = holder.createWarningAnnotation(element, "Grails configuration may be outdated");
                annotation.setFileLevelAnnotation(true);
                annotation.registerFix(new IntentionAction(){

                    @NotNull
                    public String getText() {
                        if ("Apply Grails changes to IDEA project structure" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "getText"));
                        }
                        return "Apply Grails changes to IDEA project structure";
                    }

                    @NotNull
                    public String getFamilyName() {
                        if ("Apply" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "getFamilyName"));
                        }
                        return "Apply";
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "isAvailable"));
                        }
                        return true;
                    }

                    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$1", "invoke"));
                        }
                        GrailsFramework.forceSynchronizationSetting(module);
                    }

                    public boolean startInWriteAction() {
                        return false;
                    }
                });
                annotation.registerFix(new IntentionAction(){

                    @NotNull
                    public String getText() {
                        if ("Ignore" == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "getText"));
                        }
                        return "Ignore";
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = this.getText();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "getFamilyName"));
                        }
                        return string;
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "isAvailable"));
                        }
                        return true;
                    }

                    public void invoke(@NotNull Project project, Editor editor, PsiFile f) throws IncorrectOperationException {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/grails/annotator/GrailsSynchronizeStructureAnnotator$2", "invoke"));
                        }
                        FileDocumentManager.getInstance().saveAllDocuments();
                        GrailsSettingsService.getGrailsSettings(module).updateBuildConfig(f.getText());
                        DaemonCodeAnalyzer.getInstance((Project)module.getProject()).restart();
                    }

                    public boolean startInWriteAction() {
                        return true;
                    }
                });
            }
        }
    }
}

