/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.HttpProxyConfigurable;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.plugins.AvailablePluginsModel;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginIsInstalledColumnInfo;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginsTable;
import org.jetbrains.plugins.groovy.mvc.plugins.actions.AddCustomPluginAction;
import org.jetbrains.plugins.groovy.mvc.plugins.actions.ReloadMvcPluginListAction;

public class MvcPluginsMain {
    private JPanel main;
    private JLabel myAuthorEmailLabel;
    private JLabel myAuthorLabel;
    private JEditorPane myDescriptionTextArea;
    private JLabel myPluginUrlLabel;
    private JLabel myVersionLabel;
    private JPanel myTablePanel;
    private JPanel myToolbarPanel;
    private JButton myHttpProxySettingsButton;
    private JPanel myPanelForTable;
    private final AvailablePluginsModel myAvailablePluginsModel;
    private final MvcPluginsTable myAvailablePluginsTable;
    private final ActionToolbar myActionToolbar;
    private final MyPluginsFilter myFilter;
    private final Module myModule;
    private final DialogBuilder myDialogBuilder;
    private final MvcFramework myFramework;
    @NonNls
    public static final String TEXT_PREFIX = "<html><body style=\"font-family: Arial; font-size: 12pt;\">";
    @NonNls
    public static final String TEXT_SUFFIX = "</body></html>";
    @NonNls
    private static final String HTML_PREFIX = "<html><body><a href=\"\">";
    @NonNls
    private static final String HTML_SUFFIX = "</a></body></html>";
    private final Map<MvcPluginDescriptor, String> myCustomPlugins;
    private final Map<String, MvcPluginDescriptor> myPluginDescriptions;

    public MvcPluginsMain(final Module module, DialogBuilder dialogBuilder) {
        this.$$$setupUI$$$();
        this.myFilter = new MyPluginsFilter();
        this.myCustomPlugins = new THashMap();
        this.myPluginDescriptions = new THashMap();
        this.myModule = module;
        this.myDialogBuilder = dialogBuilder;
        this.myFramework = MvcFramework.getInstance((Module)module);
        assert (this.myFramework != null);
        this.myDescriptionTextArea.addHyperlinkListener((HyperlinkListener)new PluginManagerMain.MyHyperlinkListener());
        this.main.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$1", "actionPerformed"));
                }
                IdeFocusManager.getInstance((Project)module.getProject()).requestFocus((Component)((Object)MvcPluginsMain.this.myFilter), true);
            }
        }, KeyStroke.getKeyStroke(70, 2), 1);
        Set<String> installedPlugins = this.loadPluginInfo();
        this.myAvailablePluginsModel = new AvailablePluginsModel(this.myModule, installedPlugins, this.myPluginDescriptions.values());
        this.myAvailablePluginsTable = new MvcPluginsTable(this.myAvailablePluginsModel);
        JScrollPane availableScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myAvailablePluginsTable));
        ActionGroup actionGroup = this.getActionGroup();
        this.installTableActions(this.myAvailablePluginsTable, actionGroup);
        this.myHttpProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                HttpConfigurable cfg;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$2", "actionPerformed"));
                }
                Element serializedCfg = new Element("root");
                try {
                    HttpConfigurable.getInstance().writeExternal(serializedCfg);
                    cfg = new HttpConfigurable();
                    cfg.readExternal(serializedCfg);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
                MvcPluginsMain.this.doEditProxySettings(cfg);
            }
        });
        this.myTablePanel.setMinimumSize(new Dimension(350, -1));
        this.myDescriptionTextArea.setPreferredSize(new Dimension(-1, 300));
        this.myPanelForTable.setLayout(new BorderLayout());
        this.myPanelForTable.setBorder((Border)IdeBorderFactory.createTitledBorder((String)(this.myFramework.getDisplayName() + " plugins"), (boolean)false));
        this.myPanelForTable.add((Component)availableScrollPane, "Center");
        this.myToolbarPanel.setLayout(new BorderLayout());
        this.myActionToolbar = ActionManager.getInstance().createActionToolbar("PluginManager", actionGroup, true);
        this.myToolbarPanel.add((Component)this.myActionToolbar.getComponent(), "West");
        this.myToolbarPanel.add((Component)((Object)this.myFilter), "East");
        this.myActionToolbar.updateActionsImmediately();
        MvcPluginsTable pluginTable = this.getPluginTable();
        TableUtil.ensureSelectionExists((JTable)((Object)pluginTable));
        this.myActionToolbar.updateActionsImmediately();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!StringUtil.isEmpty((String)MvcPluginsMain.this.myFilter.getFilter())) {
                    MvcPluginsMain.this.myFilter.filter();
                }
            }
        });
        dialogBuilder.setPreferredFocusComponent((JComponent)((Object)this.myAvailablePluginsTable));
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.main);
        this.tableSelectionChanged(pluginTable);
    }

    private void doEditProxySettings(final HttpConfigurable cfg) {
        if (!ShowSettingsUtil.getInstance().editConfigurable((Component)this.main, (Configurable)new HttpProxyConfigurable(cfg))) {
            return;
        }
        if (MvcConsole.getInstance((Project)this.myModule.getProject()).isExecuting()) {
            String frameworkName = this.myFramework.getDisplayName();
            Messages.showErrorDialog((Project)this.myModule.getProject(), (String)("Failed to set proxy: " + frameworkName + " Console is busy"), (String)("Can't execute " + frameworkName + " command"));
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MvcPluginsMain.this.myDialogBuilder.getWindow().isShowing()) {
                        MvcPluginsMain.this.doEditProxySettings(cfg);
                    }
                }
            });
            return;
        }
        MvcPluginUtil.setFrameworkProxy(cfg, this.myModule, this.myFramework);
    }

    public void addCustomPlugin(MvcPluginDescriptor plugin, String path) {
        this.myCustomPlugins.put(plugin, path);
        this.myPluginDescriptions.put(plugin.getName(), plugin);
        this.myFilter.clear();
        this.myAvailablePluginsTable.getModel().setData(this.myPluginDescriptions.values());
    }

    public Map<MvcPluginDescriptor, String> getCustomPlugins() {
        return this.myCustomPlugins;
    }

    private Set<String> loadPluginInfo() {
        HashSet<String> installedPlugins = new HashSet<String>();
        this.myPluginDescriptions.clear();
        for (MvcPluginDescriptor plugin : MvcPluginUtil.refreshAndLoadPluginList(this.myModule)) {
            this.myPluginDescriptions.put(plugin.getName(), plugin);
        }
        for (VirtualFile pluginDir : this.myFramework.getAllPluginRoots(this.myModule, true)) {
            VirtualFile pluginXML = pluginDir.findChild("plugin.xml");
            if (pluginXML == null) continue;
            String dirName = pluginDir.getName();
            String pluginName = null;
            int index = dirName.lastIndexOf(45);
            while (index != -1) {
                String pluginNameCandidate = dirName.substring(0, index);
                if (this.myPluginDescriptions.containsKey(pluginNameCandidate)) {
                    pluginName = pluginNameCandidate;
                    break;
                }
                index = dirName.lastIndexOf(45, index - 1);
            }
            if (pluginName == null) {
                MvcPluginDescriptor plugin = MvcPluginUtil.parsePluginXml(pluginXML);
                if (plugin == null) continue;
                this.myPluginDescriptions.put(plugin.getName(), plugin);
                installedPlugins.add(plugin.getName());
                continue;
            }
            installedPlugins.add(pluginName);
        }
        for (MvcPluginDescriptor plugin : this.myCustomPlugins.keySet()) {
            this.myPluginDescriptions.put(plugin.getName(), plugin);
        }
        return installedPlugins;
    }

    private ActionGroup getActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddCustomPluginAction(this));
        group.add((AnAction)new ReloadMvcPluginListAction(this));
        return group;
    }

    public JComponent getMainPanel() {
        return this.main;
    }

    private void installTableActions(final MvcPluginsTable pluginTable, ActionGroup actionGroup) {
        this.myAvailablePluginsModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(@NotNull TableModelEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$5", "tableChanged"));
                }
                if (0 == e.getType()) {
                    MvcPluginIsInstalledColumnInfo pluginIsInstalledColumnInfo = (MvcPluginIsInstalledColumnInfo)MvcPluginsMain.this.myAvailablePluginsModel.getColumnInfos()[0];
                    MvcPluginsMain.this.myDialogBuilder.setOkActionEnabled(pluginIsInstalledColumnInfo.getToInstallPlugins().size() > 0 || pluginIsInstalledColumnInfo.getToRemovePlugins().size() > 0);
                }
            }
        });
        pluginTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                int[] selectedObjects;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$6", "actionPerformed"));
                }
                for (int selectedRowNum : selectedObjects = pluginTable.getSelectedRows()) {
                    Object boolVal = MvcPluginsMain.this.myAvailablePluginsTable.getValueAt(selectedRowNum, 0);
                    assert (boolVal instanceof Boolean);
                    MvcPluginsMain.this.myAvailablePluginsTable.setValueAt((Boolean)boolVal == false, selectedRowNum, 0);
                    pluginTable.getSelectionModel().setSelectionInterval(selectedRowNum, selectedRowNum);
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        pluginTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$7", "valueChanged"));
                }
                MvcPluginsMain.this.tableSelectionChanged(pluginTable);
            }
        });
        PopupHandler.installUnknownPopupHandler((JComponent)((Object)pluginTable), (ActionGroup)actionGroup, (ActionManager)ActionManager.getInstance());
        this.myAuthorEmailLabel.setCursor(new Cursor(12));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$8", "onClick"));
                }
                MvcPluginDescriptor plugin = MvcPluginsMain.this.getPluginTable().getSelectedObject();
                if (plugin != null && plugin.getLastRelease() != null) {
                    MvcPluginsMain.launchBrowserAction(plugin.getLastRelease().getEmail(), "mailto:");
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myAuthorLabel);
        this.myPluginUrlLabel.setCursor(new Cursor(12));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginsMain$9", "onClick"));
                }
                MvcPluginDescriptor plugin = MvcPluginsMain.this.getPluginTable().getSelectedObject();
                if (plugin != null && plugin.getLastRelease() != null) {
                    MvcPluginsMain.launchBrowserAction(plugin.getLastRelease().getDocumentation(), "");
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myPluginUrlLabel);
        new MySpeedSearchBar(pluginTable);
    }

    private void tableSelectionChanged(MvcPluginsTable pluginTable) {
        MvcPluginDescriptor[] plugins = pluginTable.getSelectedObjects();
        MvcPluginDescriptor mvcPlugin = plugins.length == 1 ? plugins[0] : null;
        this.pluginInfoUpdate(mvcPlugin);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                MvcPluginsMain.this.myActionToolbar.updateActionsImmediately();
            }
        });
    }

    public MvcPluginsTable getPluginTable() {
        return this.myAvailablePluginsTable;
    }

    private static void launchBrowserAction(String cmd, String prefix) {
        if (cmd != null && cmd.trim().length() > 0) {
            try {
                BrowserUtil.browse((String)(prefix + cmd.trim()));
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public Module getModule() {
        return this.myModule;
    }

    public void pluginInfoUpdate(MvcPluginDescriptor plugin) {
        if (plugin != null && plugin.getLastRelease() != null) {
            MvcPluginDescriptor.Release release = plugin.getLastRelease();
            this.myAuthorLabel.setText(release.getAuthor());
            String fullDescription = release.getDescription();
            MvcPluginsMain.setTextValue(fullDescription != null ? SearchUtil.markup((String)fullDescription, (String)this.myFilter.getFilter()) : null, this.myDescriptionTextArea);
            MvcPluginsMain.setHtmlValue(release.getEmail(), this.myAuthorEmailLabel);
            MvcPluginsMain.setHtmlValue(release.getDocumentation(), this.myPluginUrlLabel);
            MvcPluginsMain.setTextValue(release.getVersion(), this.myVersionLabel);
        } else {
            this.myAuthorLabel.setText("");
            MvcPluginsMain.setTextValue(null, this.myDescriptionTextArea);
            this.myAuthorEmailLabel.setText("");
            this.myPluginUrlLabel.setText("");
            this.myVersionLabel.setText("");
        }
    }

    private static void setTextValue(String val, JEditorPane pane) {
        if (val != null) {
            if ((val = val.trim()).startsWith("\\")) {
                val = val.substring(1);
            }
            val = val.trim().replace("\n", "<br>");
            pane.setText(TEXT_PREFIX + val + TEXT_SUFFIX);
            pane.setCaretPosition(0);
        } else {
            pane.setText("<html><body style=\"font-family: Arial; font-size: 12pt;\"></body></html>");
        }
    }

    private static void setTextValue(String val, JLabel label) {
        label.setText(val != null ? val : "");
    }

    private static void setHtmlValue(String val, JLabel label) {
        boolean isValid = val != null && val.trim().length() > 0;
        String setVal = isValid ? HTML_PREFIX + val.trim() + HTML_SUFFIX : "(not specified)";
        label.setText(setVal);
        label.setCursor(isValid ? Cursor.getPredefinedCursor(12) : Cursor.getPredefinedCursor(0));
    }

    public FilterComponent getFilter() {
        return this.myFilter;
    }

    public MvcFramework getFramework() {
        return this.myFramework;
    }

    public Map<String, MvcPluginDescriptor> getPluginDescriptions() {
        return this.myPluginDescriptions;
    }

    public void markInstalled(String pluginName) {
        MvcPluginIsInstalledColumnInfo pluginIsInstalledColumnInfo = (MvcPluginIsInstalledColumnInfo)this.myAvailablePluginsModel.getColumnInfos()[0];
        pluginIsInstalledColumnInfo.getToInstallPlugins().add(pluginName);
        this.myDialogBuilder.setOkActionEnabled(true);
    }

    public void reloadPlugins() {
        this.loadPluginInfo();
        this.myFilter.clear();
        this.myAvailablePluginsTable.getModel().setData(this.myPluginDescriptions.values());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel;
        JLabel jLabel2;
        JEditorPane jEditorPane;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel4;
        this.main = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setPreferredSize(new Dimension(900, 500));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(550);
        jSplitPane.setOneTouchExpandable(true);
        jPanel5.add((Component)jSplitPane, "Center");
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jSplitPane.setRightComponent(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel6.add((Component)jPanel7, gridBagConstraints);
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/IdeBundle").getString("group.vendor"), (int)0, (int)0, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("label.plugin.vendor.name"));
        jPanel7.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("label.plugin.vendor.email"));
        jPanel7.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAuthorEmailLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.status.not.specified"));
        jPanel7.add((Component)jLabel4, new GridConstraints(1, 1, 1, 1, 8, 0, 7, 0, new Dimension(10, -1), null, null));
        this.myAuthorLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/IdeBundle").getString("plugin.status.not.specified"));
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 7, 0, new Dimension(10, -1), null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        jPanel6.add((Component)jPanel8, gridBagConstraints2);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(0, 0));
        jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel8.add((Component)jPanel9, new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 4, 0, 0)));
        jPanel9.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("editbox.plugin.description"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel9.add((Component)jBScrollPane, "Center");
        this.myDescriptionTextArea = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setText("<html>\n  <head>\n\n  </head>\n  <body>\n    <p style=\"margin-top: 0\">\n      \n    </p>\n  </body>\n</html>\n");
        jBScrollPane.setViewportView(jEditorPane);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Versions:");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(5, 4, 0, 0);
        jPanel6.add((Component)jLabel7, gridBagConstraints3);
        this.myVersionLabel = jLabel2 = new JLabel();
        jLabel2.setText("?");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 16;
        gridBagConstraints4.insets = new Insets(5, 0, 0, 0);
        jPanel6.add((Component)jLabel2, gridBagConstraints4);
        this.myPluginUrlLabel = jLabel = new JLabel();
        jLabel.setText("            ");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(5, 4, 0, 0);
        jPanel6.add((Component)jLabel, gridBagConstraints5);
        this.myTablePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jSplitPane.setLeftComponent(jPanel3);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel10, "Center");
        this.myToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel2, "North");
        this.myPanelForTable = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHttpProxySettingsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("button.http.proxy.settings"));
        jPanel11.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.main;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MySpeedSearchBar
    extends SpeedSearchBase<MvcPluginsTable> {
        public MySpeedSearchBar(MvcPluginsTable pluginsTable) {
            super((JComponent)((Object)pluginsTable));
        }

        protected int convertIndexToModel(int viewIndex) {
            return ((MvcPluginsTable)((Object)this.getComponent())).convertRowIndexToModel(viewIndex);
        }

        public int getSelectedIndex() {
            return ((MvcPluginsTable)((Object)this.myComponent)).getSelectedRow();
        }

        public Object[] getAllElements() {
            return ((MvcPluginsTable)((Object)this.myComponent)).getElements();
        }

        public String getElementText(Object element) {
            return ((MvcPluginDescriptor)element).getName();
        }

        public void selectElement(Object element, String selectedText) {
            for (int i = 0; i < ((MvcPluginsTable)((Object)this.myComponent)).getRowCount(); ++i) {
                if (!((MvcPluginsTable)((Object)this.myComponent)).getPluginAt(i).getName().equals(((MvcPluginDescriptor)element).getName())) continue;
                ((MvcPluginsTable)((Object)this.myComponent)).setRowSelectionInterval(i, i);
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
                break;
            }
        }
    }

    private class MyPluginsFilter
    extends FilterComponent {
        private final List<MvcPluginDescriptor> myFilteredAvailable;

        public MyPluginsFilter() {
            super("PLUGIN_FILTER", 5);
            this.myFilteredAvailable = new ArrayList<MvcPluginDescriptor>();
        }

        public void filter() {
            this.filter(MvcPluginsMain.this.myAvailablePluginsModel, this.myFilteredAvailable);
        }

        private void filter(AvailablePluginsModel model, List<MvcPluginDescriptor> filtered) {
            String filter = this.getFilter().toLowerCase(Locale.ENGLISH);
            SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
            Set search = optionsRegistrar.getProcessedWords(filter);
            ArrayList<MvcPluginDescriptor> current = new ArrayList<MvcPluginDescriptor>();
            LinkedHashSet<MvcPluginDescriptor> toBeProcessed = new LinkedHashSet<MvcPluginDescriptor>(model.getAvailablePlugins());
            toBeProcessed.addAll(filtered);
            filtered.clear();
            for (MvcPluginDescriptor mvcPlugin : toBeProcessed) {
                MvcPluginDescriptor.Release release;
                if (StringUtil.containsIgnoreCase((String)mvcPlugin.getName(), (String)filter)) {
                    current.add(mvcPlugin);
                    continue;
                }
                if (this.isAccepted(search, current, mvcPlugin, mvcPlugin.getName()) || (release = mvcPlugin.getLastRelease()) != null && (this.isAccepted(search, current, mvcPlugin, release.getTitle()) || this.isAccepted(search, current, mvcPlugin, release.getDescription()))) continue;
                filtered.add(mvcPlugin);
            }
            model.setData(current);
        }

        private boolean isAccepted(Set<String> search, ArrayList<MvcPluginDescriptor> current, MvcPluginDescriptor descriptor, String description) {
            if (description == null) {
                return false;
            }
            SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
            HashSet<String> descriptionSet = new HashSet<String>(search);
            descriptionSet.removeAll(optionsRegistrar.getProcessedWords(description));
            if (descriptionSet.isEmpty()) {
                current.add(descriptor);
                return true;
            }
            return false;
        }

        public void dispose() {
            super.dispose();
            this.myFilteredAvailable.clear();
        }

        public void clear() {
            this.myFilteredAvailable.clear();
            this.setFilter("");
        }
    }
}

